/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.playermodifier.IPlayerModifier;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.util.MobUtil;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ToolModifierHandler {
    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        Player player;
        if (event.getSource() == null) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        Entity trueSource = source.m_7639_();
        if (trueSource instanceof Player) {
            player = (Player)source.m_7639_();
            boolean appliedBane = false;
            int bleedLevel = 0;
            IToolModifier toolCap = (IToolModifier)player.m_21205_().getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (toolCap != null) {
                if (toolCap.hasBane()) {
                    this.applyBane(target);
                    appliedBane = true;
                }
                if (toolCap.hasBleed()) {
                    bleedLevel = toolCap.getBleedLevel();
                }
            }
            MobUtil.addBleedingEffect(bleedLevel, target, (Entity)player);
            IPlayerModifier playerCap = (IPlayerModifier)player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).orElse(null);
            if (playerCap != null) {
                if (playerCap.hasBane() && !appliedBane) {
                    this.applyBane(target);
                }
                float damage = event.getAmount();
                if (playerCap.hasHeatDamage()) {
                    damage = playerCap.getAttackDamage() == 0.0f ? (damage += playerCap.getHeatDamage()) : (damage += playerCap.getAttackDamage());
                    target.m_7311_(30 * playerCap.getHeatPieces());
                } else {
                    damage += playerCap.getAttackDamage();
                }
                if (playerCap.getAttackDamage() > 0.0f && player.m_21205_().m_41619_()) {
                    player.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)ForceSounds.FORCE_PUNCH.get(), player.m_5720_(), 1.0f, 1.0f);
                    event.setAmount(damage);
                }
            }
        }
        if (target instanceof Player) {
            player = (Player)target;
            int sturdyLevel = 0;
            for (ItemStack armorStack : player.m_6168_()) {
                IToolModifier modifierCap = (IToolModifier)armorStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                if (modifierCap == null || !modifierCap.hasSturdy()) continue;
                ++sturdyLevel;
            }
            if (sturdyLevel > 0) {
                double perArmor = (Double)ConfigHandler.COMMON.sturdyDamageReduction.get();
                double percentage = (double)sturdyLevel * (perArmor / 4.0);
                float oldDamage = event.getAmount();
                float newDamage = (float)((double)oldDamage - (double)oldDamage * percentage);
                event.setAmount(Mth.m_14036_((float)newDamage, (float)1.0f, (float)Float.MAX_VALUE));
            }
        }
    }

    private void applyBane(LivingEntity target) {
        if (target instanceof Creeper) {
            Creeper creeper = (Creeper)target;
            creeper.getCapability(CapabilityHandler.CAPABILITY_BANE).ifPresent(entityCap -> {
                if (entityCap.canExplode()) {
                    creeper.m_32283_(-1);
                    creeper.m_20088_().m_135381_(Creeper.f_32275_, (Object)false);
                    entityCap.setExplodeAbility(false);
                    creeper.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof SwellGoal);
                }
            });
        }
        if (target instanceof EnderMan) {
            EnderMan enderman = (EnderMan)target;
            enderman.getCapability(CapabilityHandler.CAPABILITY_BANE).ifPresent(entityCap -> {
                if (entityCap.canTeleport()) {
                    entityCap.setTeleportAbility(false);
                }
            });
        }
    }
}

