/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.playermodifier.IPlayerModifier;
import com.mrbysco.forcecraft.entities.projectile.ForceArrowEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LootingHandler {
    @SubscribeEvent
    public void onLooting(LootingLevelEvent event) {
        Entity entity;
        DamageSource source = event.getDamageSource();
        if (source == null || source.m_7639_() == null) {
            return;
        }
        int level = event.getLootingLevel();
        IPlayerModifier playerModifier = (IPlayerModifier)source.m_7639_().getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).orElse(null);
        int customLevel = 0;
        if (playerModifier != null) {
            customLevel += playerModifier.getLuckLevel();
        }
        if ((entity = source.m_7640_()) instanceof ForceArrowEntity) {
            ForceArrowEntity forceArrow = (ForceArrowEntity)entity;
            customLevel += forceArrow.getLuck();
        }
        if (customLevel > 4) {
            customLevel = 4;
        }
        event.setLootingLevel(level += customLevel);
    }

    @SubscribeEvent
    public void onTreasureDrop(LivingDropsEvent event) {
        if (event.getSource() == null || event.getSource().m_7639_() == null) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player) {
            Player player = (Player)source;
            player.m_21205_().getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).ifPresent(cap -> {
                if (cap.hasTreasure()) {
                    float dropChance;
                    RandomSource rand = player.m_217043_();
                    int looting = event.getLootingLevel();
                    LivingEntity entity = event.getEntity();
                    BlockPos entityPos = entity.m_20183_();
                    int chanceMax = 20;
                    if (looting > 0 && (chanceMax /= looting) < 0) {
                        chanceMax = 1;
                    }
                    if ((dropChance = (float)rand.m_188503_(chanceMax)) == 0.0f) {
                        if (entity.m_21222_()) {
                            event.getDrops().add(new ItemEntity(entity.m_9236_(), (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.UNDEATH_CARD.get(), rand.m_188503_(Math.max(1, looting)) + 1)));
                        } else if (entity instanceof Monster) {
                            event.getDrops().add(new ItemEntity(entity.m_9236_(), (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.DARKNESS_CARD.get(), rand.m_188503_(Math.max(1, looting)) + 1)));
                        } else {
                            event.getDrops().add(new ItemEntity(entity.m_9236_(), (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.LIFE_CARD.get(), rand.m_188503_(Math.max(1, looting)) + 1)));
                        }
                    }
                }
            });
        }
    }
}

