/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class AngryEndermanEntity
extends EnderMan {
    public AngryEndermanEntity(EntityType<? extends EnderMan> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 8.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new StareGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((AngryEndermanEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public boolean m_32529_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_() && !this.m_20072_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.m_32543_(d0, d1, d2);
        }
        return false;
    }

    static class StareGoal
    extends Goal {
        private final EnderMan enderman;
        private LivingEntity targetPlayer;

        public StareGoal(EnderMan endermanIn) {
            this.enderman = endermanIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.targetPlayer = this.enderman.m_5448_();
            if (!(this.targetPlayer instanceof Player)) {
                return false;
            }
            double d0 = this.targetPlayer.m_20280_((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.m_32534_((Player)this.targetPlayer);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.enderman.m_21563_().m_24946_(this.targetPlayer.m_20185_(), this.targetPlayer.m_20188_(), this.targetPlayer.m_20189_());
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final AngryEndermanEntity enderman;
        private Player player;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public FindPlayerGoal(AngryEndermanEntity endermantIn, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((Mob)endermantIn, Player.class, 10, false, false, p_i241912_2_);
            this.enderman = endermantIn;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(livingEntity -> endermantIn.m_32534_((Player)livingEntity));
        }

        public boolean m_8036_() {
            this.player = this.enderman.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.m_32533_();
        }

        public void m_8041_() {
            this.player = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.player != null) {
                if (!this.enderman.m_32534_(this.player)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.player;
                    this.player = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.m_32534_((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.m_32529_();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 128.0 && this.teleportTime++ >= 30 && this.enderman.m_32500_((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

