/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmutationRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    @Nullable
    private String group;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public TransmutationRecipeBuilder(ItemStack result) {
        this.result = result;
        this.requires((ItemLike)ForceRegistry.FORCE_ROD.get());
        this.m_126132_("has_rod", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)ForceRegistry.FORCE_ROD.get()}).m_45077_()}));
    }

    public static TransmutationRecipeBuilder transmutation(ItemLike resultItem) {
        return new TransmutationRecipeBuilder(new ItemStack(resultItem, 1));
    }

    public static TransmutationRecipeBuilder transmutation(ItemLike resultItem, int count) {
        return new TransmutationRecipeBuilder(new ItemStack(resultItem, count));
    }

    public static TransmutationRecipeBuilder transmutation(ItemStack result) {
        return new TransmutationRecipeBuilder(result);
    }

    public TransmutationRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(Ingredient.m_204132_(pTag));
    }

    public TransmutationRecipeBuilder requires(ItemLike pItem) {
        return this.requires(pItem, 1);
    }

    public TransmutationRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}));
        }
        return this;
    }

    public TransmutationRecipeBuilder requires(Ingredient pIngredient) {
        return this.requires(pIngredient, 1);
    }

    public TransmutationRecipeBuilder requires(Ingredient pIngredient, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.ingredients.add((Object)pIngredient);
        }
        return this;
    }

    public RecipeBuilder m_126132_(String id, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(id, triggerInstance);
        return this;
    }

    public TransmutationRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeConsumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        recipeConsumer.accept((FinishedRecipe)new Result(id, this.group == null ? "" : this.group, this.result, this.ingredients, this.advancement, id.m_246208_("recipes/transmutation/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final String group;
        private final ItemStack result;
        private final NonNullList<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(CraftingBookCategory.MISC);
            this.id = id;
            this.group = group;
            this.result = result;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsArray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientsArray);
            json.add("result", Result.serializeItemStack(this.result));
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForceRecipeSerializers.TRANSMUTATION_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        static JsonElement serializeItemStack(@NotNull ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            if (stack.m_41613_() > 1) {
                json.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                json.addProperty("nbt", stack.m_41783_().toString());
            }
            return json;
        }
    }
}

