/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen;

import com.mrbysco.forcecraft.datagen.assets.ForceBlockModelProvider;
import com.mrbysco.forcecraft.datagen.assets.ForceBlockStateProvider;
import com.mrbysco.forcecraft.datagen.assets.ForceItemModelProvider;
import com.mrbysco.forcecraft.datagen.assets.ForceLanguageProvider;
import com.mrbysco.forcecraft.datagen.data.ForceDamageTypeProvider;
import com.mrbysco.forcecraft.datagen.data.ForceLootModifierProvider;
import com.mrbysco.forcecraft.datagen.data.ForceLootProvider;
import com.mrbysco.forcecraft.datagen.data.ForceRecipeProvider;
import com.mrbysco.forcecraft.datagen.data.tags.ForceBlockTagProvider;
import com.mrbysco.forcecraft.datagen.data.tags.ForceDamageTypeTagProvider;
import com.mrbysco.forcecraft.datagen.data.tags.ForceItemTagProvider;
import com.mrbysco.forcecraft.datagen.patchouli.PatchouliProvider;
import com.mrbysco.forcecraft.world.feature.ForceBiomeModifiers;
import com.mrbysco.forcecraft.world.feature.ForceFeatureKeys;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForceDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(ForceDataGen::getProvider);
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new ForceLootProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new ForceRecipeProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new PatchouliProvider(packOutput));
            ForceBlockTagProvider provider = new ForceBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(event.includeServer(), (DataProvider)provider);
            generator.addProvider(event.includeServer(), (DataProvider)new ForceItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)provider, existingFileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new ForceDamageTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new ForceLootModifierProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(ForceDataGen::getProvider), Set.of("forcecraft")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new ForceLanguageProvider(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new ForceBlockModelProvider(packOutput, existingFileHelper));
            generator.addProvider(event.includeClient(), (DataProvider)new ForceBlockStateProvider(packOutput, existingFileHelper));
            generator.addProvider(event.includeClient(), (DataProvider)new ForceItemModelProvider(packOutput, existingFileHelper));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_268580_, ForceDamageTypeProvider::bootstrap);
        registryBuilder.m_254916_(Registries.f_256911_, ForceFeatureKeys::configuredBootstrap);
        registryBuilder.m_254916_(Registries.f_256988_, ForceFeatureKeys::placedBootstrap);
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ForceBiomeModifiers::modifierBootstrap);
        registryBuilder.m_254916_(Registries.f_256952_, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }
}

