/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.engine;

import com.mrbysco.forcecraft.blockentities.ForceEngineBlockEntity;
import com.mrbysco.forcecraft.client.util.RenderHelper;
import com.mrbysco.forcecraft.menu.engine.ForceEngineMenu;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;

public class ForceEngineScreen
extends AbstractContainerScreen<ForceEngineMenu> {
    private final ResourceLocation TEXTURE = new ResourceLocation("forcecraft", "textures/gui/container/force_engine.png");

    public ForceEngineScreen(ForceEngineMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.drawFuelTank(guiGraphics);
        this.drawThrottleTank(guiGraphics);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<Object> text;
        int actualMouseX = mouseX - (this.f_96543_ - this.f_97726_) / 2;
        int actualMouseY = mouseY - (this.f_96544_ - this.f_97727_) / 2;
        ForceEngineBlockEntity tile = ((ForceEngineMenu)this.m_6262_()).getTile();
        if (this.m_6774_(66, 11, 16, 58, mouseX, mouseY)) {
            text = new ArrayList<Object>();
            if (tile.getFuelFluid() == null) {
                text.add(Component.m_237115_((String)"gui.forcecraft.force_engine.empty"));
            } else if (tile.getFuelFluidStack() != null) {
                text.add(tile.getFuelFluidStack().getDisplayName());
                text.add(Component.m_237113_((String)(tile.getFuelAmount() + " mb")).m_130940_(ChatFormatting.GOLD));
            }
            guiGraphics.m_280666_(this.f_96547_, text, actualMouseX, actualMouseY);
        }
        if (this.m_6774_(94, 11, 16, 58, mouseX, mouseY)) {
            text = new ArrayList();
            if (tile.getThrottleFluid() == null) {
                text.add(Component.m_237115_((String)"gui.forcecraft.force_engine.empty"));
            } else if (tile.getThrottleFluidStack() != null) {
                text.add(tile.getThrottleFluidStack().getDisplayName());
                text.add(Component.m_237113_((String)(tile.getThrottleAmount() + " mb")).m_130940_(ChatFormatting.GOLD));
            }
            guiGraphics.m_280666_(this.f_96547_, text, actualMouseX, actualMouseY);
        }
    }

    private void drawFuelTank(GuiGraphics guiGraphics) {
        if (((ForceEngineMenu)this.f_97732_).getTile() == null || ((ForceEngineMenu)this.f_97732_).getTile().getFuelFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((ForceEngineMenu)this.f_97732_).getTile().getFuelFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((ForceEngineMenu)this.m_6262_()).getTile().getFuelAmount(), 10000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.f_97735_ + 66, this.f_97736_ + 11, tankPercentage, 58);
        guiGraphics.m_280218_(this.TEXTURE, this.f_97735_ + 66, this.f_97736_ + 11, 176, 0, 16, 64);
    }

    private void drawThrottleTank(GuiGraphics guiGraphics) {
        if (((ForceEngineMenu)this.f_97732_).getTile() == null || ((ForceEngineMenu)this.f_97732_).getTile().getThrottleFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((ForceEngineMenu)this.f_97732_).getTile().getThrottleFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((ForceEngineMenu)this.m_6262_()).getTile().getThrottleAmount(), 10000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.f_97735_ + 94, this.f_97736_ + 11, tankPercentage, 58);
        guiGraphics.m_280218_(this.TEXTURE, this.f_97735_ + 94, this.f_97736_ + 11, 176, 0, 16, 64);
    }
}

