/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities.playermodifier;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.playermodifier.IPlayerModifier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PlayerModifierCapability
implements IPlayerModifier,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    private float attackDamage = (float)Attributes.f_22281_.m_22082_();
    private float wingPower;
    private float flightCounter = this.wingPower = 0.0f;
    private float heatDamage = 0.0f;
    private int heatPieces = 0;
    private int armorPieces = 0;
    private float damage = this.attackDamage + this.heatDamage;
    private int luck;
    private boolean bane;
    private int bleeding;

    @Override
    public float getAttackDamage() {
        return this.attackDamage;
    }

    @Override
    public void setAttackDamage(float newDamage) {
        this.attackDamage = newDamage;
    }

    @Override
    public void addAttackDamage(float newDamage) {
        this.attackDamage += newDamage;
    }

    @Override
    public float getWingPower() {
        return this.wingPower;
    }

    @Override
    public void setWingPower(float newWingPower) {
        this.wingPower = newWingPower;
    }

    @Override
    public float getFlightTimer() {
        return this.flightCounter;
    }

    @Override
    public void subtractFlightTimer() {
        this.flightCounter -= 1.0f;
    }

    @Override
    public void setFlightTimer(float newFlightCounter) {
        this.flightCounter = newFlightCounter;
    }

    @Override
    public float getHeatDamage() {
        return this.heatDamage;
    }

    @Override
    public void setHeatDamage(float newDamage) {
        this.heatDamage = newDamage;
    }

    @Override
    public boolean hasHeatDamage() {
        return this.heatDamage > 0.0f;
    }

    @Override
    public void setHeatPieces(int pieces) {
        this.heatPieces = pieces;
    }

    @Override
    public int getHeatPieces() {
        return this.heatPieces;
    }

    @Override
    public void addHeatDamage(float newDamage) {
        this.heatDamage += newDamage;
    }

    @Override
    public float getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(float newDamage) {
        this.damage = newDamage;
    }

    @Override
    public int getLuckLevel() {
        return this.luck;
    }

    @Override
    public void setLuckLevel(int newLuck) {
        this.luck = newLuck;
    }

    @Override
    public void incrementLuckLevel(int newLuck) {
        this.luck += newLuck;
    }

    @Override
    public boolean hasFullSet() {
        return this.armorPieces == 4;
    }

    @Override
    public int getArmorPieces() {
        return this.armorPieces;
    }

    @Override
    public void incrementArmorPieces() {
        ++this.armorPieces;
    }

    @Override
    public void setArmorPieces(int value) {
        this.armorPieces = value;
    }

    @Override
    public boolean hasBane() {
        return this.bane;
    }

    @Override
    public void setBane(boolean value) {
        this.bane = value;
    }

    @Override
    public boolean hasBleeding() {
        return this.bleeding > 0;
    }

    @Override
    public int getBleedingLevel() {
        return this.bleeding;
    }

    @Override
    public void setBleeding(int value) {
        this.bleeding = value;
    }

    public CompoundTag serializeNBT() {
        return PlayerModifierCapability.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        PlayerModifierCapability.readNBT(this, nbt);
    }

    public static CompoundTag writeNBT(IPlayerModifier instance) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("attackDamage", instance.getAttackDamage());
        tag.m_128350_("wingPower", instance.getWingPower());
        tag.m_128350_("flightCounter", instance.getFlightTimer());
        tag.m_128350_("damage", instance.getDamage());
        tag.m_128350_("heatDamage", instance.getHeatDamage());
        tag.m_128405_("heatPieces", instance.getHeatPieces());
        tag.m_128405_("luckLevel", instance.getLuckLevel());
        tag.m_128405_("armorPieces", instance.getArmorPieces());
        tag.m_128379_("bane", instance.hasBane());
        tag.m_128405_("bleeding", instance.getBleedingLevel());
        return tag;
    }

    public static void readNBT(IPlayerModifier instance, CompoundTag tag) {
        instance.setAttackDamage(tag.m_128457_("attackDamage"));
        instance.setWingPower(tag.m_128457_("wingPower"));
        instance.setFlightTimer(tag.m_128457_("flightCounter"));
        instance.setDamage(tag.m_128457_("damage"));
        instance.setHeatDamage(tag.m_128457_("heatDamage"));
        instance.setHeatPieces(tag.m_128451_("heatPieces"));
        instance.setLuckLevel(tag.m_128451_("luckLevel"));
        instance.setArmorPieces(tag.m_128451_("armorPieces"));
        instance.setBane(tag.m_128471_("bane"));
        instance.setBleeding(tag.m_128451_("bleeding"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.CAPABILITY_PLAYERMOD.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public final Capability<IPlayerModifier> getCapability() {
        return CapabilityHandler.CAPABILITY_PLAYERMOD;
    }
}

