/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities.magnet;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.magnet.IMagnet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class MagnetCapability
implements IMagnet,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    boolean active;

    @Override
    public boolean isActivated() {
        return this.active;
    }

    @Override
    public void activate() {
        this.active = true;
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    @Override
    public void setActivation(boolean value) {
        this.active = value;
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).ifPresent(cap -> {
            if (cap.isActivated()) {
                tooltip.add((Component)Component.m_237115_((String)"forcecraft.magnet_glove.active").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"forcecraft.magnet_glove.deactivated").m_130940_(ChatFormatting.RED));
            }
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"forcecraft.magnet_glove.change").m_130940_(ChatFormatting.BOLD));
        });
    }

    public CompoundTag serializeNBT() {
        return MagnetCapability.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        MagnetCapability.readNBT(this, nbt);
    }

    public static CompoundTag writeNBT(IMagnet instance) {
        if (instance == null) {
            return null;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("activated", instance.isActivated());
        return nbt;
    }

    public static void readNBT(IMagnet instance, CompoundTag tag) {
        instance.setActivation(tag.m_128471_("activated"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.CAPABILITY_MAGNET.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public final Capability<IMagnet> getCapability() {
        return CapabilityHandler.CAPABILITY_MAGNET;
    }
}

