/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities.forcewrench;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.forcewrench.IForceWrench;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ForceWrenchCapability
implements IForceWrench,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    CompoundTag storedBlockNBT = null;
    BlockState storedBlockState = null;
    String name = "";

    @Override
    public boolean hasBlockStored() {
        return this.storedBlockState != null;
    }

    @Override
    public boolean canStoreBlock() {
        return this.hasBlockStored();
    }

    @Override
    public CompoundTag getStoredBlockNBT() {
        return this.storedBlockNBT;
    }

    @Override
    public BlockState getStoredBlockState() {
        return this.storedBlockState;
    }

    @Override
    public String getStoredName() {
        return this.name;
    }

    @Override
    public void storeBlockNBT(CompoundTag nbt) {
        this.storedBlockNBT = nbt;
    }

    @Override
    public void storeBlockState(BlockState base) {
        this.storedBlockState = base;
    }

    @Override
    public void setBlockName(String name) {
        this.name = name;
    }

    @Override
    public void clearBlockStorage() {
        this.storedBlockState = null;
        this.storedBlockNBT = null;
        this.name = "";
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).ifPresent(cap -> {
            if (cap.getStoredName() != null && !cap.getStoredName().isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Stored: ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)cap.getStoredName()).m_130940_(ChatFormatting.GRAY)));
            }
        });
    }

    public CompoundTag serializeNBT() {
        return ForceWrenchCapability.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        ForceWrenchCapability.readNBT(this, nbt);
    }

    public static CompoundTag writeNBT(IForceWrench instance) {
        if (instance == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        if (instance.getStoredBlockNBT() != null) {
            tag.m_128365_("storedNBT", (Tag)instance.getStoredBlockNBT());
        }
        if (instance.getStoredBlockState() != null) {
            tag.m_128365_("storedBlockState", (Tag)NbtUtils.m_129202_((BlockState)instance.getStoredBlockState()));
        }
        if (!instance.getStoredName().isEmpty()) {
            tag.m_128359_("name", instance.getStoredName());
        }
        return tag;
    }

    public static void readNBT(IForceWrench instance, CompoundTag tag) {
        instance.storeBlockNBT(tag.m_128469_("storedNBT"));
        if (tag.m_128441_("storedBlockState")) {
            instance.storeBlockState(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("storedBlockState")));
        }
        instance.setBlockName(tag.m_128461_("name"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.CAPABILITY_FORCEWRENCH.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public final Capability<IForceWrench> getCapability() {
        return CapabilityHandler.CAPABILITY_FORCEWRENCH;
    }
}

