/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities.forcerod;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.util.ForceUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ForceRodCapability
implements IForceRodModifier,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    boolean camo = false;
    boolean ender = false;
    boolean sight = false;
    int speed = 0;
    int healing = 0;
    GlobalPos homeLocation = null;
    boolean light;

    @Override
    public int getHealingLevel() {
        return this.healing;
    }

    @Override
    public boolean hasHealing() {
        return this.healing > 0;
    }

    @Override
    public void incrementHealing() {
        ++this.healing;
    }

    @Override
    public void setHealing(int newHealing) {
        this.healing = newHealing;
    }

    @Override
    public boolean hasCamoModifier() {
        return this.camo;
    }

    @Override
    public void setCamoModifier(boolean newVal) {
        this.camo = newVal;
    }

    @Override
    public GlobalPos getHomeLocation() {
        return this.homeLocation;
    }

    @Override
    public void setHomeLocation(GlobalPos globalPos) {
        this.homeLocation = globalPos;
    }

    @Override
    public void teleportPlayerToLocation(Player player, GlobalPos globalPos) {
        if (player.m_9236_().m_46472_().m_135782_().equals((Object)globalPos.m_122640_().m_135782_())) {
            BlockPos pos = globalPos.m_122646_();
            int x = pos.m_123341_();
            int y = pos.m_123342_() + 1;
            int z = pos.m_123343_();
            ForceUtils.teleportToLocation(player, x, y, z, true);
        } else if (!player.m_9236_().f_46443_) {
            player.m_213846_((Component)Component.m_237115_((String)"forcecraft.ender_rod.dimension.text").m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Override
    public boolean hasEnderModifier() {
        return this.ender;
    }

    @Override
    public void setEnderModifier(boolean newVal) {
        this.ender = newVal;
    }

    @Override
    public boolean isRodofEnder() {
        return this.ender;
    }

    @Override
    public boolean hasSightModifier() {
        return this.sight;
    }

    @Override
    public void setSightModifier(boolean newVal) {
        this.sight = newVal;
    }

    @Override
    public boolean hasLight() {
        return this.light;
    }

    @Override
    public void setLight(boolean val) {
        this.light = val;
    }

    @Override
    public int getSpeedLevel() {
        return this.speed;
    }

    @Override
    public void incrementSpeed() {
        this.setSpeed(this.speed + 1);
    }

    @Override
    public void setSpeed(int newSpeed) {
        this.speed = Math.min(3, newSpeed);
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
            if (cap.hasHealing()) {
                tooltip.add((Component)Component.m_237115_((String)("item.infuser.tooltip.healing" + cap.getHealingLevel())).m_130940_(ChatFormatting.RED));
            }
            if (cap.getSpeedLevel() > 0) {
                tooltip.add((Component)Component.m_237115_((String)("item.infuser.tooltip.speed" + cap.getSpeedLevel())));
            }
            if (cap.hasCamoModifier()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.camo").m_130940_(ChatFormatting.DARK_GREEN));
            }
            if (cap.hasEnderModifier()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.ender").m_130940_(ChatFormatting.DARK_PURPLE));
                if (cap.getHomeLocation() != null) {
                    GlobalPos globalPos = cap.getHomeLocation();
                    BlockPos pos = globalPos.m_122646_();
                    tooltip.add((Component)Component.m_237110_((String)"forcecraft.ender_rod.location", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), globalPos.m_122640_().m_135782_()}).m_130940_(ChatFormatting.YELLOW));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"forcecraft.ender_rod.unset").m_130940_(ChatFormatting.RED));
                }
                tooltip.add((Component)Component.m_237115_((String)"forcecraft.ender_rod.text").m_130940_(ChatFormatting.GRAY));
            }
            if (cap.hasSightModifier()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.sight").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            if (cap.hasLight()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.light").m_130940_(ChatFormatting.YELLOW));
            }
        });
    }

    public CompoundTag serializeNBT() {
        return ForceRodCapability.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        ForceRodCapability.readNBT(this, nbt);
    }

    public static CompoundTag writeNBT(IForceRodModifier instance) {
        if (instance == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("speed", instance.getSpeedLevel());
        tag.m_128405_("healing", instance.getHealingLevel());
        if (instance.getHomeLocation() != null) {
            tag.m_128379_("HasHome", true);
            tag.m_128356_("HomeLocation", instance.getHomeLocation().m_122646_().m_121878_());
            tag.m_128359_("HomeDimension", instance.getHomeLocation().m_122640_().m_135782_().toString());
        }
        tag.m_128379_("camo", instance.hasCamoModifier());
        tag.m_128379_("ender", instance.hasEnderModifier());
        tag.m_128379_("sight", instance.hasSightModifier());
        tag.m_128379_("light", instance.hasLight());
        return tag;
    }

    public static void readNBT(IForceRodModifier instance, CompoundTag tag) {
        instance.setSpeed(tag.m_128451_("speed"));
        instance.setHealing(tag.m_128451_("healing"));
        if (tag.m_128471_("HasHome")) {
            BlockPos pos = BlockPos.m_122022_((long)tag.m_128454_("HomeLocation"));
            ResourceLocation location = ResourceLocation.m_135820_((String)tag.m_128461_("HomeDimension"));
            if (location != null) {
                ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
                instance.setHomeLocation(GlobalPos.m_122643_((ResourceKey)dimension, (BlockPos)pos));
            }
        }
        instance.setCamoModifier(tag.m_128471_("camo"));
        instance.setEnderModifier(tag.m_128471_("ender"));
        instance.setSightModifier(tag.m_128471_("sight"));
        instance.setLight(tag.m_128471_("light"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.CAPABILITY_FORCEROD.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public final Capability<IForceRodModifier> getCapability() {
        return CapabilityHandler.CAPABILITY_FORCEROD;
    }
}

