/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidHandlerWrapper
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    public static final String NBT_INPUT = "Input";
    public static final String NBT_OUTPUT = "Output";
    protected final FluidTank throttleTank;
    protected final FluidTank fuelTank;

    public FluidHandlerWrapper(FluidTank throttle, FluidTank fuel) {
        this.throttleTank = throttle;
        this.fuelTank = fuel;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBT_INPUT, (Tag)this.throttleTank.writeToNBT(new CompoundTag()));
        tag.m_128365_(NBT_OUTPUT, (Tag)this.fuelTank.writeToNBT(new CompoundTag()));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_(NBT_OUTPUT)) {
            this.fuelTank.readFromNBT(tag.m_128469_(NBT_OUTPUT));
        }
        if (tag.m_128441_(NBT_INPUT)) {
            this.throttleTank.readFromNBT(tag.m_128469_(NBT_INPUT));
        }
    }

    public int getTanks() {
        return 2;
    }

    public FluidStack getFluidInTank(int tank) {
        switch (tank) {
            default: {
                return this.fuelTank.getFluid();
            }
            case 1: 
        }
        return this.throttleTank.getFluid();
    }

    public int getTankCapacity(int tank) {
        switch (tank) {
            default: {
                return this.fuelTank.getCapacity();
            }
            case 1: 
        }
        return this.throttleTank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        switch (tank) {
            default: {
                return this.fuelTank.isFluidValid(stack);
            }
            case 1: 
        }
        return this.throttleTank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (this.fuelTank.isFluidValid(resource)) {
            int count = this.fuelTank.fill(resource, action);
            return count < 1000 ? 0 : count;
        }
        int count = this.throttleTank.fill(resource, action);
        return count < 1000 ? 0 : count;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.fuelTank.isFluidValid(resource)) {
            return this.fuelTank.drain(resource, action);
        }
        return this.throttleTank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fuelTank.getFluidAmount() > 0) {
            return this.fuelTank.drain(maxDrain, action);
        }
        return this.throttleTank.drain(maxDrain, action);
    }
}

