/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.infuser;

import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class InfuserBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)5.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)5.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)5.0, (double)14.0), Block.m_49796_((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public InfuserBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InfuserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return InfuserBlock.createInfuserTicker(level, blockEntityType, (BlockEntityType<? extends InfuserBlockEntity>)((BlockEntityType)ForceRegistry.INFUSER_BLOCK_ENTITY.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createInfuserTicker(Level level, BlockEntityType<T> p_151989_, BlockEntityType<? extends InfuserBlockEntity> infuserBlockEntityType) {
        return level.f_46443_ ? null : InfuserBlock.m_152132_(p_151989_, infuserBlockEntityType, InfuserBlockEntity::serverTick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof InfuserBlockEntity) {
            InfuserBlockEntity infuserBE = (InfuserBlockEntity)blockentity;
            LazyOptional fluidHandler = blockentity.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_());
            fluidHandler.ifPresent(handler -> {
                if (playerIn.m_21120_(handIn).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                    FluidUtil.interactWithFluidHandler((Player)playerIn, (InteractionHand)handIn, (Level)level, (BlockPos)pos, (Direction)hit.m_82434_());
                } else if (!level.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)infuserBE, (BlockPos)pos);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof InfuserBlockEntity) {
                blockentity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighbourBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.f_46443_) {
            InfuserBlockEntity infuserBE;
            boolean flag = level.m_276867_(pos);
            BlockEntity blockentity = level.m_7702_(pos);
            if (flag && blockentity instanceof InfuserBlockEntity && (infuserBE = (InfuserBlockEntity)blockentity).hasValidRecipe() && !infuserBE.canWork) {
                infuserBE.startWork();
                infuserBE.m_6596_();
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof InfuserBlockEntity) {
            InfuserBlockEntity infuserTile = (InfuserBlockEntity)blockentity;
            if (infuserTile.processTime > 0) {
                double d0 = (double)pos.m_123341_() + 0.5;
                double d1 = (double)pos.m_123342_() + 0.5;
                double d2 = (double)pos.m_123343_() + 0.5;
                Direction direction = Direction.UP;
                Direction.Axis direction$axis = direction.m_122434_();
                for (int i = 0; i < 3; ++i) {
                    double d3 = 0.52;
                    double d4 = rand.nextDouble() * 0.6 - 0.3;
                    double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * d3 : d4;
                    double d6 = rand.nextDouble() * 6.0 / 16.0;
                    double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * d3 : d4;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123789_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

