/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.engine;

import com.mrbysco.forcecraft.blockentities.ForceEngineBlockEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Random;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ForceEngineBlock
extends DirectionalBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_UP = Stream.of(Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)11.0, (double)4.0, (double)3.0, (double)15.0, (double)11.0, (double)13.0), Block.m_49796_((double)1.0, (double)4.0, (double)3.0, (double)5.0, (double)11.0, (double)13.0), Block.m_49796_((double)3.0, (double)4.0, (double)12.0, (double)13.0, (double)10.0, (double)14.0), Block.m_49796_((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)10.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_DOWN = Stream.of(Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)11.0, (double)5.0, (double)3.0, (double)15.0, (double)12.0, (double)13.0), Block.m_49796_((double)1.0, (double)5.0, (double)3.0, (double)5.0, (double)12.0, (double)13.0), Block.m_49796_((double)3.0, (double)6.0, (double)2.0, (double)13.0, (double)12.0, (double)4.0), Block.m_49796_((double)3.0, (double)6.0, (double)12.0, (double)13.0, (double)12.0, (double)14.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), Block.m_49796_((double)11.0, (double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)12.0), Block.m_49796_((double)1.0, (double)3.0, (double)5.0, (double)5.0, (double)13.0, (double)12.0), Block.m_49796_((double)3.0, (double)12.0, (double)6.0, (double)13.0, (double)14.0, (double)12.0), Block.m_49796_((double)3.0, (double)2.0, (double)6.0, (double)13.0, (double)4.0, (double)12.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_EAST = Stream.of(Block.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.m_49796_((double)4.0, (double)3.0, (double)11.0, (double)11.0, (double)13.0, (double)15.0), Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)11.0, (double)13.0, (double)5.0), Block.m_49796_((double)4.0, (double)12.0, (double)3.0, (double)10.0, (double)14.0, (double)13.0), Block.m_49796_((double)4.0, (double)2.0, (double)3.0, (double)10.0, (double)4.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), Block.m_49796_((double)11.0, (double)3.0, (double)4.0, (double)15.0, (double)13.0, (double)11.0), Block.m_49796_((double)1.0, (double)3.0, (double)4.0, (double)5.0, (double)13.0, (double)11.0), Block.m_49796_((double)3.0, (double)2.0, (double)4.0, (double)13.0, (double)4.0, (double)10.0), Block.m_49796_((double)3.0, (double)12.0, (double)4.0, (double)13.0, (double)14.0, (double)10.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_WEST = Stream.of(Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), Block.m_49796_((double)5.0, (double)3.0, (double)11.0, (double)12.0, (double)13.0, (double)15.0), Block.m_49796_((double)5.0, (double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)5.0), Block.m_49796_((double)6.0, (double)2.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0), Block.m_49796_((double)6.0, (double)12.0, (double)3.0, (double)12.0, (double)14.0, (double)13.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public ForceEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ForceEngineBlockEntity) {
            LazyOptional fluidHandler = blockentity.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_());
            fluidHandler.ifPresent(handler -> {
                if (player.m_21120_(handIn).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                    FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (Level)level, (BlockPos)pos, (Direction)hit.m_82434_());
                } else if (!level.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((ForceEngineBlockEntity)blockentity), (BlockPos)pos);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> super.m_5940_(state, level, pos, context);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, ACTIVE});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)mirrorIn.m_54848_((Direction)state.m_61143_((Property)f_52588_)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction.m_122424_()));
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_((Property)f_52588_) == direction ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_()))) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction.m_122424_())).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) != level.m_276867_(pos)) {
            if (flag) {
                level.m_186460_(pos, (Block)this, 4);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)ACTIVE), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && !level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)ACTIVE), 2);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ForceEngineBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ForceEngineBlock.createEngineTicker(level, blockEntityType, (BlockEntityType<? extends ForceEngineBlockEntity>)((BlockEntityType)ForceRegistry.FORCE_ENGINE_BLOCK_ENTITY.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createEngineTicker(Level level, BlockEntityType<T> p_151989_, BlockEntityType<? extends ForceEngineBlockEntity> forceEngineBlockEntity) {
        return level.f_46443_ ? null : ForceEngineBlock.createTickerHelper(p_151989_, forceEngineBlockEntity, ForceEngineBlockEntity::serverTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    public static ToIntFunction<BlockState> getLightValueActive(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)ACTIVE) != false ? lightValue : 0;
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)ACTIVE)).booleanValue()) {
            Direction direction = (Direction)stateIn.m_61143_((Property)f_52588_);
            double d0 = (double)pos.m_123341_() + 0.55 - (double)(rand.m_188501_() * 0.1f);
            double d1 = (double)pos.m_123342_() + 0.55 - (double)(rand.m_188501_() * 0.1f);
            double d2 = (double)pos.m_123343_() + 0.55 - (double)(rand.m_188501_() * 0.1f);
            double d3 = 0.4f - (rand.m_188501_() + rand.m_188501_()) * 0.4f;
            if (rand.m_188503_(5) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + (double)direction.m_122429_() * d3, d1 + (double)direction.m_122430_() * d3, d2 + (double)direction.m_122431_() * d3, rand.m_188583_() * 0.005, rand.m_188583_() * 0.005, rand.m_188583_() * 0.005);
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ForceEngineBlockEntity) {
                ForceEngineBlockEntity engineTile = (ForceEngineBlockEntity)blockEntity;
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)engineTile.inputHandler.getStackInSlot(0));
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)engineTile.inputHandler.getStackInSlot(1));
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)engineTile.outputHandler.getStackInSlot(0));
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)engineTile.outputHandler.getStackInSlot(1));
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

