/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mrbysco.forcecraft.blockentities.InfuserModifierType;
import com.mrbysco.forcecraft.blockentities.energy.ForceEnergyStorage;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.capabilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeTomeItem;
import com.mrbysco.forcecraft.items.tools.ForceAxeItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShearsItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import com.mrbysco.forcecraft.items.tools.ForceSwordItem;
import com.mrbysco.forcecraft.menu.infuser.InfuserMenu;
import com.mrbysco.forcecraft.networking.PacketHandler;
import com.mrbysco.forcecraft.networking.message.StopInfuserSoundMessage;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.storage.StorageManager;
import com.mrbysco.forcecraft.util.EnchantUtils;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class InfuserBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    private static final int FLUID_CHARGE = 1000;
    public boolean canWork = false;
    public boolean makesSpecialSound = false;
    public int processTime = 0;
    public int maxProcessTime = 20;
    public static final int SLOT_TOOL = 8;
    public static final int SLOT_GEM = 9;
    public static final int SLOT_BOOK = 10;
    public static final int ENERGY_COST_PER = 20;
    public static final int FLUID_COST_PER = 1000;
    private static final int FLUID_PER_GEM = 500;
    protected Map<Integer, InfuseRecipe> currentRecipes = new HashMap<Integer, InfuseRecipe>();
    protected FluidTank tank = new FluidTank(50000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!InfuserBlockEntity.this.isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = InfuserBlockEntity.this.tank.getFluidAmount() - resource.getAmount() < 0 ? InfuserBlockEntity.this.tank.getFluidAmount() : resource.getAmount();
                return new FluidStack(InfuserBlockEntity.this.tank.getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            InfuserBlockEntity.this.refreshClient();
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return super.drain(maxDrain, action);
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_205067_(ForceTags.FORCE);
        }
    };
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    public final ItemStackHandler handler = new ItemStackHandler(11){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 9) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 8) {
                return InfuserBlockEntity.this.matchesModifier(stack);
            }
            if (slot == 8) {
                return InfuserBlockEntity.this.matchesTool(stack);
            }
            if (slot == 10) {
                return stack.m_41720_() == ForceRegistry.UPGRADE_TOME.get();
            }
            if (slot == 9) {
                return stack.m_41720_() == ForceRegistry.FORCE_GEM.get();
            }
            return true;
        }
    };
    private final LazyOptional<IItemHandler> handlerHolder = LazyOptional.of(() -> this.handler);
    public ForceEnergyStorage energyStorage = new ForceEnergyStorage(64000, 1000);
    private final LazyOptional<ForceEnergyStorage> energyHolder = LazyOptional.of(() -> this.energyStorage);
    private final NonNullList<ItemStack> infuserContents = NonNullList.m_122779_();

    public InfuserBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public InfuserBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ForceRegistry.INFUSER_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        this.processTime = compound.m_128451_("processTime");
        this.maxProcessTime = compound.m_128451_("maxProcessTime");
        this.canWork = compound.m_128471_("canWork");
        this.handler.deserializeNBT(compound.m_128469_("ItemStackHandler"));
        ContainerHelper.m_18980_((CompoundTag)compound, this.infuserContents);
        this.energyStorage.setEnergy(compound.m_128451_("EnergyHandler"));
        this.tank.readFromNBT(compound);
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128405_("processTime", this.processTime);
        compound.m_128405_("maxProcessTime", this.maxProcessTime);
        compound.m_128379_("canWork", this.canWork);
        compound.m_128365_("ItemStackHandler", (Tag)this.handler.serializeNBT());
        compound.m_128405_("EnergyHandler", this.energyStorage.getEnergyStored());
        ContainerHelper.m_18973_((CompoundTag)compound, this.infuserContents);
        this.tank.writeToNBT(compound);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, InfuserBlockEntity infuser) {
        if (infuser.handler.getStackInSlot(9).m_41720_() == ForceRegistry.FORCE_GEM.get()) {
            infuser.processForceGems();
        }
        if (infuser.canWork) {
            ++infuser.processTime;
            if (level.m_46467_() % 60L == 0L) {
                infuser.makeWorkSound();
            }
            if (infuser.energyStorage.getEnergyStored() > 20) {
                infuser.energyStorage.consumePower(20);
            }
            if (infuser.processTime < infuser.maxProcessTime) {
                return;
            }
            infuser.processTime = 0;
            if (infuser.isWorkAllowed()) {
                if (infuser.areAllModifiersEmpty() && infuser.canCharge()) {
                    infuser.processForceCharging();
                } else if (infuser.recipesStillMatch()) {
                    infuser.processTool();
                }
                infuser.stopWorkSound();
                if (infuser.makesSpecialSound) {
                    infuser.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL_DONE.get(), 1.0f, 1.0f);
                } else {
                    infuser.playSound((SoundEvent)ForceSounds.INFUSER_DONE.get(), 1.0f, 1.0f);
                }
                infuser.makesSpecialSound = false;
            }
            infuser.canWork = false;
            infuser.processTime = 0;
            infuser.refreshClient();
        } else {
            infuser.processTime = 0;
        }
    }

    public void startWork() {
        this.canWork = true;
        this.processTime = 0;
        this.setMaxTimeFromRecipes();
        if (this.areAllModifiersEmpty() && this.canCharge()) {
            this.maxProcessTime = (Integer)ConfigHandler.COMMON.forceInfusingTime.get();
        }
        if (this.maxProcessTime <= 0) {
            this.canWork = false;
            this.maxProcessTime = 0;
        }
        if (this.canWork) {
            this.stopWorkSound();
            this.makesSpecialSound = false;
            if (this.f_58857_.f_46441_.m_188503_(10) == 0) {
                this.makesSpecialSound = true;
                this.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL_BEEP.get(), 1.0f, 1.0f);
            }
            this.makeWorkSound();
        }
        this.refreshClient();
    }

    public void makeWorkSound() {
        if (this.makesSpecialSound) {
            this.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL.get(), 1.0f, 1.0f);
        } else {
            this.playSound((SoundEvent)ForceSounds.INFUSER_WORKING.get(), 1.0f, 1.0f);
        }
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        BlockPos pos = this.m_58899_();
        this.f_58857_.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), event, SoundSource.BLOCKS, volume, pitch);
    }

    public void stopWorkSound() {
        if (!this.f_58857_.f_46443_) {
            BlockPos pos = this.m_58899_();
            for (Player playerentity : this.f_58857_.m_6907_()) {
                if (!(playerentity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 200.0)) continue;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)playerentity), (Object)new StopInfuserSoundMessage());
            }
        }
    }

    private void setMaxTimeFromRecipes() {
        ArrayList<InfuseRecipe> recipes;
        this.maxProcessTime = 0;
        if (!this.getBookInSlot().m_41619_() && !(recipes = new ArrayList<InfuseRecipe>(this.getMatchingRecipes().values())).isEmpty()) {
            for (InfuseRecipe recipeCurrent : recipes) {
                this.maxProcessTime += recipeCurrent.getTime();
            }
        }
    }

    protected Map<Integer, InfuseRecipe> getMatchingRecipes() {
        if (this.getBookInSlot().m_41619_()) {
            return new HashMap<Integer, InfuseRecipe>();
        }
        if (!this.currentRecipes.isEmpty() && this.recipesStillMatch()) {
            return this.currentRecipes;
        }
        HashMap<Integer, InfuseRecipe> matchingRecipes = new HashMap<Integer, InfuseRecipe>();
        block0: for (int i = 0; i < 8; ++i) {
            ItemStack modifier = this.getModifier(i);
            if (modifier.m_41619_()) continue;
            List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ForceRecipes.INFUSER_TYPE.get());
            for (InfuseRecipe recipe : recipes) {
                if (!recipe.matchesModifier(this, modifier, false)) continue;
                matchingRecipes.put(i, recipe);
                continue block0;
            }
        }
        this.currentRecipes = matchingRecipes;
        return this.currentRecipes;
    }

    protected boolean matchesModifier(ItemStack stack) {
        if (this.f_58857_ != null) {
            List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ForceRecipes.INFUSER_TYPE.get());
            for (InfuseRecipe recipe : recipes) {
                if (!recipe.matchesModifier(this, stack)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean matchesTool(ItemStack toolStack) {
        if (this.f_58857_ != null) {
            List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ForceRecipes.INFUSER_TYPE.get());
            for (InfuseRecipe recipe : recipes) {
                if (!recipe.matchesTool(toolStack, true)) continue;
                return true;
            }
        }
        return toolStack.m_204117_(ForceTags.VALID_INFUSER_CHARGE);
    }

    protected boolean recipesStillMatch() {
        for (Map.Entry<Integer, InfuseRecipe> entry : this.currentRecipes.entrySet()) {
            ItemStack modifier = this.getModifier(entry.getKey());
            if (entry.getValue().matchesModifier(this, modifier, false)) continue;
            return false;
        }
        return true;
    }

    private void refreshClient() {
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
    }

    private void processForceGems() {
        FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 500);
        if (this.tank.getFluidAmount() + force.getAmount() <= this.tank.getCapacity()) {
            this.fill(force, IFluidHandler.FluidAction.EXECUTE);
            this.handler.getStackInSlot(9).m_41774_(1);
            this.refreshClient();
        }
    }

    public boolean areAllModifiersEmpty() {
        int emptySlots = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.handler.getStackInSlot(i).m_41619_()) continue;
            ++emptySlots;
        }
        return emptySlots == 8;
    }

    private void processForceCharging() {
        ItemStack tool = this.getFromToolSlot();
        ForceToolData force = new ForceToolData(tool);
        int charge = 1000;
        if (tool.m_41768_()) {
            int ratio = 25;
            int damage = tool.m_41773_();
            int repaired = 0;
            for (int i = 0; i < damage; ++i) {
                if (charge < 25) continue;
                ++repaired;
                charge -= 25;
            }
            tool.m_41721_(damage - repaired);
        }
        if (charge > 0) {
            force.charge(charge);
        }
        this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        force.write(tool);
    }

    private void processTool() {
        for (Map.Entry<Integer, InfuseRecipe> entry : this.currentRecipes.entrySet()) {
            ItemStack tool;
            boolean success;
            ItemStack modifier = this.getModifier(entry.getKey());
            InfuseRecipe recipe = entry.getValue();
            if (!recipe.matchesModifier(this, modifier, true) || !(success = this.applyModifier(tool = this.getFromToolSlot(), modifier, recipe))) continue;
            modifier.m_41774_(1);
            this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            UpgradeTomeItem.onModifierApplied(this.getBookInSlot(), modifier, tool);
        }
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlerHolder.cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankHolder.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean hasTool() {
        ItemStack tool = this.getFromToolSlot();
        return !tool.m_41619_();
    }

    public boolean hasValidBook() {
        ItemStack tool = this.getBookInSlot();
        if (!tool.m_41619_()) {
            return tool.m_41720_() == ForceRegistry.UPGRADE_TOME.get();
        }
        return false;
    }

    public ItemStack getFromToolSlot() {
        return this.handler.getStackInSlot(8);
    }

    public ItemStack getBookInSlot() {
        return this.handler.getStackInSlot(10);
    }

    public ItemStack getModifier(int slot) {
        if (slot >= 0 && slot <= 7) {
            return this.handler.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    public boolean hasValidModifer(int slot) {
        return !this.getModifier(slot).m_41619_();
    }

    public boolean canCharge() {
        ItemStack tool = this.getFromToolSlot();
        return this.isValidChargeableStack(tool) && this.tank.getFluidAmount() > 1000;
    }

    public boolean isValidChargeableStack(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return stack.m_204117_(ForceTags.VALID_INFUSER_CHARGE) && tag != null && tag.m_128441_("ForceInfused") && stack.m_41613_() == 1;
    }

    private boolean applyModifier(ItemStack tool, ItemStack modifier, InfuseRecipe recipe) {
        UpgradeBookData bd = new UpgradeBookData(this.getBookInSlot());
        if (recipe.resultModifier.apply(tool, modifier, bd)) {
            bd.onRecipeApply(recipe, this.getBookInSlot());
            if (recipe.resultModifier == InfuserModifierType.ITEM && recipe.hasOutput()) {
                this.handler.setStackInSlot(8, recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
            } else {
                this.handler.setStackInSlot(8, tool);
            }
            return true;
        }
        return false;
    }

    static boolean applyCamo(ItemStack tool, ItemStack mod) {
        List effects = PotionUtils.m_43547_((ItemStack)mod);
        for (MobEffectInstance e : effects) {
            if (e.m_19544_() == MobEffects.f_19611_) {
                return InfuserBlockEntity.addSightModifier(tool);
            }
            if (e.m_19544_() != MobEffects.f_19609_) continue;
            return InfuserBlockEntity.addCamoModifier(tool);
        }
        return false;
    }

    static boolean addLightModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        if (item instanceof ForceRodItem) {
            IForceRodModifier rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
            if (rodCap != null && !rodCap.hasLight()) {
                rodCap.setLight(true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasLight()) {
            modifierCap.setLight(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    private static boolean addCamoModifier(ItemStack stack) {
        IToolModifier toolCap;
        Item item = stack.m_41720_();
        if (item instanceof ForceRodItem) {
            IForceRodModifier rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
            if (rodCap != null && !rodCap.hasCamoModifier()) {
                rodCap.setCamoModifier(true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (toolCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !toolCap.hasCamo()) {
            toolCap.setCamo(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    private static boolean addSightModifier(ItemStack stack) {
        IForceRodModifier rodCap;
        if (stack.m_41720_() instanceof ForceRodItem && (rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) != null && !rodCap.hasSightModifier()) {
            rodCap.setSightModifier(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addWingModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasWing()) {
                modifierCap2.setWing(true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasWing()) {
            modifierCap.setWing(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addBaneModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasBane()) {
                modifierCap2.setBane(1);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && !modifierCap3.hasBane()) {
                modifierCap3.setBane(1);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap != null && !modifierCap.hasBane()) {
            modifierCap.setBane(1);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addBleedingModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.bleedCap.get();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getBleedLevel() < MAX_CAP) {
                modifierCap2.incrementBleed();
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getBleedLevel() < MAX_CAP) {
                modifierCap3.incrementBleed();
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getBleedLevel() < MAX_CAP) {
            modifierCap.incrementBleed();
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addEnderModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        if (item instanceof ForceRodItem) {
            IForceRodModifier rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
            if (rodCap != null && !rodCap.isRodofEnder()) {
                rodCap.setEnderModifier(true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasEnder()) {
                modifierCap2.setEnder(true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasEnder()) {
            modifierCap.setEnder(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addFreezingModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if (stack.m_41720_() instanceof ForceBowItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasFreezing()) {
            modifierCap.setFreezing(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addHealingModifier(ItemStack stack) {
        IForceRodModifier rodCap;
        if (stack.m_41720_() instanceof ForceRodItem && (rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) != null) {
            int MAX_CAP = (Integer)ConfigHandler.COMMON.healingCap.get();
            if (rodCap.getHealingLevel() < MAX_CAP) {
                rodCap.incrementHealing();
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        }
        return false;
    }

    static boolean addLumberjackModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if (stack.m_41720_() instanceof ForceAxeItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasLumberjack()) {
            modifierCap.setLumberjack(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addRainbowModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if (stack.m_41720_() instanceof ForceShearsItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null) {
            modifierCap.setRainbow(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addTreasureModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if ((stack.m_41720_() instanceof ForceSwordItem || stack.m_41720_() instanceof ForceAxeItem) && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasTreasure()) {
            modifierCap.setTreasure(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean upgradeBag(ItemStack stack, UpgradeBookData bd) {
        if (stack.m_41720_() instanceof ForcePackItem) {
            PackItemStackHandler handler = StorageManager.getOrCreatePack(stack).getInventory();
            if (handler.canUpgrade(bd)) {
                handler.applyUpgrade();
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("SlotsUsed", ItemHandlerUtils.getUsedSlots((IItemHandler)handler));
                tag.m_128405_("SlotsTotal", handler.getSlotsInUse());
                tag.m_128405_("BookTier", handler.getUpgrades());
                stack.m_41751_(tag);
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean addSturdyModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        if (item instanceof ForceSwordItem || item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceRodItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getSturdyLevel() < (Integer)ConfigHandler.COMMON.sturdyToolCap.get()) {
                modifierCap2.incrementSturdy();
                EnchantUtils.incrementLevel(stack, Enchantments.f_44986_);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getSturdyLevel() == 0) {
            modifierCap.incrementSturdy();
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addLuckModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.luckCap.get();
        if (item instanceof ForcePickaxeItem || item instanceof ForceShovelItem || item instanceof ForceAxeItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getLuckLevel() < MAX_CAP) {
                modifierCap2.incrementLuck();
                EnchantUtils.incrementLevel(stack, Enchantments.f_44987_);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getLuckLevel() < MAX_CAP) {
                modifierCap3.incrementLuck();
                EnchantUtils.incrementLevel(stack, Enchantments.f_44982_);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap4 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap4 != null && modifierCap4.getLuckLevel() < MAX_CAP) {
                modifierCap4.incrementLuck();
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getLuckLevel() < MAX_CAP) {
            modifierCap.incrementLuck();
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addDamageModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.damageCap.get();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getSharpLevel() < MAX_CAP) {
                modifierCap2.incrementSharp();
                EnchantUtils.incrementLevel(stack, Enchantments.f_44977_);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getSharpLevel() < MAX_CAP) {
                modifierCap3.incrementSharp();
                EnchantUtils.incrementLevel(stack, Enchantments.f_44988_);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getSharpLevel() < 1) {
            modifierCap.incrementSharp();
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addSilkTouchModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        if ((item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem) && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasSilk()) {
            modifierCap.setSilk(true);
            stack.m_41663_(Enchantments.f_44985_, 1);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addForceModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.forceCap.get();
        if ((item instanceof ForceSwordItem || item instanceof ForceAxeItem) && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getForceLevel() < MAX_CAP) {
            modifierCap.incrementForce();
            EnchantUtils.incrementLevel(stack, Enchantments.f_44980_);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addHeatModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.m_41720_();
        if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceShearsItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasHeat()) {
                modifierCap2.setHeat(true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem || item instanceof ForceAxeItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && !modifierCap3.hasHeat()) {
                stack.m_41663_(Enchantments.f_44981_, 1);
                modifierCap3.setHeat(true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasHeat()) {
            modifierCap.setHeat(true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addSpeedModifier(ItemStack stack) {
        IForceRodModifier modifierCap;
        Item item = stack.m_41720_();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.speedCap.get();
        if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceAxeItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getSpeedLevel() < MAX_CAP) {
                modifierCap2.incrementSpeed();
                EnchantUtils.incrementLevel(stack, Enchantments.f_44984_);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getSpeedLevel() < 1) {
                modifierCap3.incrementSpeed();
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem) {
            IToolModifier modifierCap4 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap4 != null && modifierCap4.getSpeedLevel() < 1) {
                modifierCap4.incrementSpeed();
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceRodItem && (modifierCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) != null && modifierCap.getSpeedLevel() < (Integer)ConfigHandler.COMMON.rodSpeedCap.get()) {
            modifierCap.incrementSpeed();
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static void addInfusedTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("ForceInfused")) {
            tag.m_128379_("ForceInfused", true);
            stack.m_41751_(tag);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tank.getFluid().isEmpty() || this.tank.getFluid().isFluidEqual(resource))) {
            this.tank.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid();
        }
        return null;
    }

    public boolean isWorkAllowed() {
        return this.hasTool() && this.hasValidBook();
    }

    public boolean hasValidRecipe() {
        return this.isWorkAllowed() && (this.areAllModifiersEmpty() && this.canCharge() || this.allSlotsMatchRecipe());
    }

    public boolean updateValidRecipe() {
        if (this.canWork) {
            this.canWork = false;
            this.processTime = 0;
            this.refreshClient();
        }
        return this.hasValidRecipe();
    }

    public boolean allSlotsMatchRecipe() {
        int requiredForce = 0;
        int requiredPower = 0;
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ForceRecipes.INFUSER_TYPE.get());
        boolean foundMatch = false;
        for (InfuseRecipe recipe : recipes) {
            ItemStack centerStack = this.getFromToolSlot();
            int amountFound = 0;
            for (int i = 0; i < 8; ++i) {
                ItemStack modifier = this.getModifier(i);
                if (modifier.m_41619_() || !recipe.matchesModifier(this, modifier, false)) continue;
                foundMatch = true;
                ++amountFound;
                requiredForce += 1000;
                requiredPower += recipe.getTime() * 20;
            }
            if (amountFound <= 0 || amountFound <= recipe.getModifier().getLevelCap(centerStack)) continue;
            return false;
        }
        if (!foundMatch) {
            return false;
        }
        return this.getFluidAmount() >= requiredForce && this.getEnergy() >= requiredPower;
    }

    public int getBookTier() {
        if (!this.getBookInSlot().m_41619_()) {
            return new UpgradeBookData(this.getBookInSlot()).getTier().ordinal();
        }
        return 0;
    }

    public int getEnergyCostPer() {
        return 20;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void setFluidAmount(int amount) {
        if (amount > 0) {
            if (!this.tank.getFluid().isEmpty()) {
                this.tank.getFluid().setAmount(amount);
            }
        } else {
            this.tank.setFluid(FluidStack.EMPTY);
        }
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public void setEnergyStored(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    public float getFluidPercentage() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    protected boolean isFluidEqual(FluidStack fluid) {
        return this.isFluidEqual(fluid.getFluid());
    }

    protected boolean isFluidEqual(Fluid fluid) {
        return this.tank.getFluid().getFluid().equals(fluid);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"forcecraft.container.infuser");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new InfuserMenu(id, playerInv, this);
    }

    public void m_6211_() {
    }

    public ItemStack m_7407_(int arg0, int arg1) {
        return ItemStack.f_41583_;
    }

    public int m_6643_() {
        return 0;
    }

    public ItemStack m_8020_(int arg0) {
        return ItemStack.f_41583_;
    }

    public boolean m_7983_() {
        return false;
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public ItemStack m_8016_(int arg0) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int arg0, ItemStack arg1) {
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.tankHolder.invalidate();
        this.handlerHolder.invalidate();
        this.energyHolder.invalidate();
    }
}

