/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.data.client.ModSoundsProvider;
import com.stal111.forbidden_arcanus.data.particle.ParticleDataProvider;
import com.stal111.forbidden_arcanus.data.recipes.ApplyModifierRecipeProvider;
import com.stal111.forbidden_arcanus.data.recipes.ClibanoRecipeProvider;
import com.stal111.forbidden_arcanus.data.recipes.CraftingRecipeProvider;
import com.stal111.forbidden_arcanus.data.server.loot.ModLootModifierProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModBiomeTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModBlockTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModDamageTypeTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModEnchantmentTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModEntityTypeTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModItemTagsProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.api.datagen.DataProviderContext;
import net.valhelsia.valhelsia_core.api.datagen.recipes.ValhelsiaRecipeProvider;

@Mod.EventBusSubscriber(modid="forbidden_arcanus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        DataProviderContext context = new DataProviderContext(event.getGenerator().getPackOutput(), event.getLookupProvider(), ForbiddenArcanus.REGISTRY_MANAGER);
        generator.addProvider(event.includeClient(), (DataProvider)new ModSoundsProvider(context, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ParticleDataProvider(context));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, ForbiddenArcanus.REGISTRY_MANAGER.buildRegistrySet(), Set.of("forbidden_arcanus")));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(context);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(context, fileHelper, blockTagsProvider.m_274426_()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEnchantmentTagsProvider(context, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagsProvider(context, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(context, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagsProvider(context, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ValhelsiaRecipeProvider(context, new Function[]{CraftingRecipeProvider::new, ClibanoRecipeProvider::new, ApplyModifierRecipeProvider::new}));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootModifierProvider(output));
    }
}

