/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.compat.emi.EmiIntegration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class MarketEmiRecipe
implements EmiRecipe {
    private final UUID uuid;
    private final ResourceLocation id;
    private final List<EmiStack> input;
    private final List<EmiStack> output;

    public MarketEmiRecipe(IMarketEntry marketEntry) {
        this.uuid = marketEntry.getEntryId();
        this.id = new ResourceLocation("farmingforblockheads", "/market/%s".formatted(marketEntry.getEntryId().toString()));
        this.input = List.of(EmiStack.of((ItemStack)marketEntry.getCostItem()));
        this.output = List.of(EmiStack.of((ItemStack)marketEntry.getOutputItem()));
    }

    public EmiRecipeCategory getCategory() {
        return EmiIntegration.MARKET_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of(this.input));
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 86;
    }

    public int getDisplayHeight() {
        return 48;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiIntegration.BACKGROUND, 0, 0);
        widgets.addSlot((EmiIngredient)this.input.get(0), 15, 12);
        widgets.addSlot((EmiIngredient)this.output.get(0), 53, 12).recipeContext((EmiRecipe)this);
        widgets.addTexture(EmiIntegration.TRADE_ICON, 35, 13);
        Component costText = this.getFormattedCostString();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92852_((FormattedText)costText);
        widgets.addText(costText, (int)(42.0f - (float)stringWidth / 2.0f), 35, 0xFFFFFF, true);
    }

    private Component getFormattedCostString() {
        MutableComponent result = Component.m_237110_((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{this.input.get(0).getAmount(), this.input.get(0).getItemStack().m_41611_()});
        ChatFormatting color = ChatFormatting.GREEN;
        if (this.input.get(0).getItemStack().m_41720_() == Items.f_42415_) {
            color = ChatFormatting.AQUA;
        }
        result.m_130940_(color);
        return result;
    }
}

