/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.permutated.exmachinis.ConfigHolder;
import net.permutated.exmachinis.util.TranslationKey;

public class UpgradeItem
extends Item {
    private final Tier tier;

    public UpgradeItem(Tier tier) {
        super(new Item.Properties().m_41487_(tier.stackSize).setNoRepair());
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        int cost = 0;
        int time = 1;
        switch (this.getTier()) {
            case GOLD: {
                cost = (Integer)ConfigHolder.SERVER.goldEnergyPerBlock.get();
                time = (Integer)ConfigHolder.SERVER.goldTicksPerOperation.get();
                break;
            }
            case DIAMOND: {
                cost = (Integer)ConfigHolder.SERVER.diamondEnergyPerBlock.get();
                time = (Integer)ConfigHolder.SERVER.diamondTicksPerOperation.get();
                break;
            }
            case NETHERITE: {
                cost = (Integer)ConfigHolder.SERVER.netheriteEnergyPerBlock.get();
                time = (Integer)ConfigHolder.SERVER.netheriteTicksPerOperation.get();
            }
        }
        MutableComponent stackSize = Component.m_237119_();
        MutableComponent itemsProcessed = Component.m_237119_();
        MutableComponent energyPerTick = Component.m_237119_();
        for (int i = 1; i <= this.getTier().stackSize; ++i) {
            ChatFormatting style = i == stack.m_41613_() ? ChatFormatting.WHITE : ChatFormatting.GRAY;
            int count = this.getTier().getItemsProcessed(i);
            int perTick = count * cost / time;
            stackSize.m_7220_((Component)Component.m_237113_((String)String.valueOf(i)).m_130940_(style));
            itemsProcessed.m_7220_((Component)Component.m_237113_((String)String.valueOf(count)).m_130940_(style));
            energyPerTick.m_7220_((Component)Component.m_237113_((String)String.valueOf(perTick)).m_130940_(style));
            if (i >= this.getTier().stackSize) continue;
            stackSize.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.GRAY));
            itemsProcessed.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.GRAY));
            energyPerTick.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)TranslationKey.translateTooltip("stackSize", stackSize).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("itemsProcessed", itemsProcessed).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("energyPerTick", energyPerTick).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("costPerBlock", cost).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("processingTime", time).m_130940_(ChatFormatting.GRAY));
    }

    public static enum Tier {
        GOLD(3),
        DIAMOND(3),
        NETHERITE(1);

        final int stackSize;

        private Tier(int stackSize) {
            this.stackSize = stackSize;
        }

        public int getItemsProcessed(int stackCount) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case GOLD -> 1 << stackCount;
                case DIAMOND -> 1 << 3 + stackCount;
                case NETHERITE -> 64;
            };
        }
    }
}

