/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.material;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.data.loading.DatagenModLoader;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.client.CompostColors;
import thedarkcolour.exdeorum.material.AbstractMaterial;
import thedarkcolour.exdeorum.material.MaterialParser;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.EItems;

public class MaterialRegistry<M extends AbstractMaterial>
implements Iterable<M> {
    private final List<M> values = new ArrayList<M>();
    private final String configSubfolder;
    private final String suffix;

    public MaterialRegistry(String configSubfolder) {
        this(configSubfolder, configSubfolder);
    }

    public MaterialRegistry(String configSubfolder, String suffix) {
        this.configSubfolder = configSubfolder;
        this.suffix = suffix;
        Preconditions.checkArgument((!suffix.startsWith("_") ? 1 : 0) != 0);
    }

    public void search(Function<MaterialParser, @Nullable M> materialRegistrar) {
        Path configPath = Paths.get("config/exdeorum/" + this.configSubfolder + "_materials", new String[0]);
        if (!DatagenModLoader.isRunningDataGen() && CompostColors.createConfigFolder(configPath)) {
            File materialsFolder = configPath.toFile();
            String[] children = materialsFolder.list();
            if (children != null) {
                for (String child : children) {
                    if (!child.endsWith(".json")) continue;
                    Path jsonPath = configPath.resolve(child);
                    try {
                        JsonObject json = (JsonObject)JsonParser.parseString((String)Files.readString(jsonPath));
                        AbstractMaterial material = (AbstractMaterial)materialRegistrar.apply(new MaterialParser(json, jsonPath, this));
                        if (material == null) continue;
                        this.register(child.substring(0, child.length() - 5), material);
                    }
                    catch (IOException e) {
                        ExDeorum.LOGGER.error("Failed to read JSON custom material at {}", (Object)jsonPath);
                    }
                }
            } else {
                ExDeorum.LOGGER.error("Failed to read JSON custom materials at {}: not a directory", (Object)configPath);
            }
        }
    }

    public void register(String name, M material) {
        String id = name + "_" + this.suffix;
        ExDeorum.LOGGER.info("Registered \"{}\" for {} material {}.json", new Object[]{id, this.configSubfolder, name});
        if (((AbstractMaterial)material).block != null) {
            throw new IllegalStateException(this.configSubfolder + " material with name " + name + " already registered: duplicate material?");
        }
        ((AbstractMaterial)material).block = EBlocks.BLOCKS.register(id, () -> material.createBlock());
        ((AbstractMaterial)material).item = EItems.ITEMS.register(id, () -> material.createBlockItem((Block)material.block.get()));
        this.values.add(material);
    }

    public <B extends BlockEntity> BlockEntityType<B> createBlockEntityType(BlockEntityType.BlockEntitySupplier<? extends B> factory) {
        ImmutableSet.Builder validBlocks = ImmutableSet.builder();
        for (AbstractMaterial material : this.values) {
            validBlocks.add((Object)((Block)material.block.get()));
        }
        return new BlockEntityType(factory, (Set)validBlocks.build(), null);
    }

    @Override
    public Iterator<M> iterator() {
        return this.values.iterator();
    }

    public Stream<M> stream() {
        return this.values.stream();
    }
}

