/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.item.WideWateringCanItem;
import thedarkcolour.exdeorum.registry.ESounds;
import thedarkcolour.exdeorum.tag.EBlockTags;

public class WateringCanItem
extends Item {
    private static final int WATERING_INTERVAL = 4;
    private static final int STARTUP_TIME = 10;
    private static boolean isWatering = false;
    private final int capacity;
    private final boolean renewing;
    private final boolean usableInMachines;

    public WateringCanItem(int capacity, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
        this.renewing = capacity >= 4000;
        this.usableInMachines = false;
    }

    protected WateringCanItem(boolean usableInMachines, Item.Properties properties) {
        super(properties);
        this.capacity = 4000;
        this.renewing = true;
        this.usableInMachines = usableInMachines;
    }

    public static ItemStack getFull(Supplier<? extends Item> wateringCan) {
        ItemStack stack = new ItemStack((ItemLike)wateringCan.get());
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> handler.fill(new FluidStack((Fluid)Fluids.f_76193_, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.renewing ? stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> handler.getFluidInTank(0).getAmount() < this.capacity).orElse(true) : true;
    }

    public int m_142159_(ItemStack pStack) {
        return 4159204;
    }

    public int m_142158_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> Math.round((float)fluidHandler.getFluidInTank(0).getAmount() * 13.0f / (float)this.capacity)).orElse(0);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> tooltip.add((Component)Component.m_237115_((String)"block.minecraft.water").m_7220_((Component)Component.m_237110_((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{fluidHandler.getFluidInTank(0).getAmount(), this.capacity})).m_130940_(ChatFormatting.GRAY)));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        return itemInHand.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> {
            Block patt6294$temp;
            BlockPos pos;
            BlockState state;
            BlockHitResult hitResult;
            if (fluidHandler.getFluidInTank(0).getAmount() < this.capacity && (hitResult = WateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).m_6662_() == HitResult.Type.BLOCK && (state = level.m_8055_(pos = hitResult.m_82425_())).m_60819_().m_76152_() == Fluids.f_76193_ && (patt6294$temp = state.m_60734_()) instanceof BucketPickup) {
                BucketPickup pickup = (BucketPickup)patt6294$temp;
                if (!level.f_46443_) {
                    fluidHandler.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    pickup.m_142598_((LevelAccessor)level, pos, state);
                    pickup.getPickupSound(state).ifPresent(sound -> player.m_5496_(sound, 1.0f, 1.0f));
                }
                return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)level.f_46443_);
            }
            if (!fluidHandler.getFluidInTank(0).isEmpty()) {
                boolean realPlayer;
                boolean bl = realPlayer = !(player instanceof FakePlayer);
                if (realPlayer) {
                    player.m_6672_(hand);
                } else if (this.usableInMachines) {
                    this.m_5929_(level, (LivingEntity)player, itemInHand, 72000);
                }
                return InteractionResultHolder.m_19096_((Object)itemInHand);
            }
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }).orElse(InteractionResultHolder.m_19098_((Object)itemInHand));
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int remainingTicks) {
        int useTicks = 72000 - remainingTicks;
        if (useTicks >= 10 || living instanceof FakePlayer) {
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> {
                block13: {
                    block8: {
                        block9: {
                            block10: {
                                BlockState state;
                                BlockPos pos;
                                block11: {
                                    block12: {
                                        BlockHitResult blockHit;
                                        double d;
                                        if (fluidHandler.getFluidInTank(0).isEmpty()) break block8;
                                        if (living instanceof Player) {
                                            Player player = (Player)living;
                                            d = player.getBlockReach();
                                        } else {
                                            d = living.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
                                        }
                                        double reachDist = d;
                                        HitResult hit = living.m_19907_(reachDist, 0.0f, true);
                                        if (!(hit instanceof BlockHitResult) || (blockHit = (BlockHitResult)hit).m_6662_() != HitResult.Type.BLOCK) break block9;
                                        pos = blockHit.m_82425_();
                                        state = level.m_8055_(pos);
                                        if (level.f_46443_) break block10;
                                        if (useTicks % 4 != 0) break block11;
                                        this.tryWatering((ServerLevel)level, pos, state);
                                        if (this.renewing && fluidHandler.getFluidInTank(0).getAmount() == this.capacity) break block11;
                                        if (!(living instanceof Player)) break block12;
                                        Player player = (Player)living;
                                        if (player.m_150110_().f_35937_) break block11;
                                    }
                                    ((CapabilityProvider)((Object)fluidHandler)).drain();
                                }
                                if (useTicks % 2 == 0) {
                                    this.waterParticles(level, pos, state);
                                }
                                if ((useTicks - 10) % 20 == 0) {
                                    level.m_5594_(null, pos, (SoundEvent)ESounds.WATERING_CAN_USE.get(), living.m_5720_(), ((Object)((Object)this)).getClass() == WideWateringCanItem.class ? 0.6f : 0.3f, 1.5f);
                                }
                                break block13;
                            }
                            isWatering = true;
                            break block13;
                        }
                        isWatering = false;
                        break block13;
                    }
                    living.m_5810_();
                    isWatering = false;
                }
            });
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int timeCharged) {
        if (timeCharged > 10) {
            level.m_7785_(living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)ESounds.WATERING_CAN_STOP.get(), living.m_5720_(), 0.6f, 0.7f, false);
        }
    }

    protected void tryWatering(ServerLevel level, BlockPos pos, BlockState state) {
        BlockPos below;
        BlockState belowState;
        if (state.m_204336_(EBlockTags.WATERING_CAN_TICKABLE)) {
            if (state.m_204336_(BlockTags.f_13104_)) {
                if (level.f_46441_.m_188503_(3) == 0) {
                    state.m_222972_(level, pos, level.f_46441_);
                    level.m_46796_(1505, pos, 0);
                }
            } else {
                Block block = state.m_60734_();
                if (block instanceof SugarCaneBlock) {
                    SugarCaneBlock block2 = (SugarCaneBlock)block;
                    BlockPos.MutableBlockPos cursor = pos.m_122032_();
                    while (level.m_46739_((BlockPos)cursor.m_122184_(0, 1, 0)) && level.m_8055_((BlockPos)cursor).m_60734_() == block2) {
                    }
                    BlockState topState = level.m_8055_((BlockPos)cursor.m_122184_(0, -1, 0));
                    topState.m_222972_(level, (BlockPos)cursor, level.f_46441_);
                } else {
                    state.m_222972_(level, pos, level.f_46441_);
                }
            }
        } else if (BarrelBlockEntity.isHotFluid(state.m_60819_().getFluidType())) {
            level.m_46796_(1501, pos, 0);
        } else if (state.m_60734_() == Blocks.f_50093_) {
            WateringCanItem.hydrateFarmland(level, pos, state);
        }
        if ((belowState = level.m_8055_(below = pos.m_7495_())).m_60734_() == Blocks.f_50093_) {
            WateringCanItem.hydrateFarmland(level, below, belowState);
        }
    }

    private static void hydrateFarmland(ServerLevel level, BlockPos pos, BlockState state) {
        BlockPos randomPos = pos.m_7918_(level.f_46441_.m_216332_(-1, 1), 0, level.f_46441_.m_216332_(-1, 1));
        if (randomPos != pos && (state = level.m_8055_(pos = randomPos)).m_60734_() != Blocks.f_50093_) {
            return;
        }
        if ((Integer)state.m_61143_((Property)FarmBlock.f_53243_) < 7) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)));
        }
    }

    protected void waterParticles(Level level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)pos.m_123341_() + 0.5 + level.f_46441_.m_188583_() / 8.0;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5 + level.f_46441_.m_188583_() / 8.0;
            VoxelShape collisionShape = state.m_60812_((BlockGetter)level, pos);
            if (!collisionShape.m_83281_()) {
                y += collisionShape.m_83297_(Direction.Axis.Y);
            }
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (!level.f_46441_.m_188499_()) continue;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123761_, x + (double)i * 0.33, y, z + (double)j * 0.33, 2, 0.0, 0.0, 0.0, 0.2);
                }
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityProvider(stack, this.capacity);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ClientExtensions.INSTANCE);
    }

    private static class CapabilityProvider
    extends FluidHandlerItemStack {
        public CapabilityProvider(@NotNull ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == Fluids.f_76193_;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return false;
        }

        public void drain() {
            FluidStack contained = this.getFluid();
            int drainAmount = Math.min(contained.getAmount(), 1);
            FluidStack drained = contained.copy();
            drained.setAmount(drainAmount);
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
    }

    private static enum ClientExtensions implements IClientItemExtensions
    {
        INSTANCE;


        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            if (player.m_6117_()) {
                int useTicks = 71999 - player.m_21212_();
                float step = (float)useTicks + partialTick;
                float startProgress = ClientExtensions.easeOutCubic(Math.min(step, 10.0f) / 10.0f);
                poseStack.m_85837_(-0.2 * (double)startProgress, -0.2 * (double)startProgress, 0.0);
                if (startProgress == 1.0f && isWatering) {
                    float sin = Mth.m_14031_((float)(0.35f * (step - 10.0f)));
                    poseStack.m_272245_(Axis.f_252529_.m_252977_(10.0f * sin), 0.0f, 0.0f, -0.2f);
                }
                float rotate = Mth.m_14179_((float)startProgress, (float)0.0f, (float)((float)Math.PI / 180));
                poseStack.m_272245_(Axis.f_252403_.m_252961_(rotate * 15.0f), -0.75f, 0.0f, 0.0f);
                int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                poseStack.m_252880_((float)i * 0.56f, -0.52f + (player.m_6117_() ? 0.0f : equipProcess) * -0.6f, -0.72f);
                return true;
            }
            return false;
        }

        private static float easeOutCubic(float progress) {
            float opposite = 1.0f - progress;
            return 1.0f - opposite * opposite * opposite;
        }
    }
}

