/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client.screen;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.data.TranslationKeys;
import thedarkcolour.exdeorum.menu.AbstractMachineMenu;

public class RedstoneControlWidget
implements GuiEventListener,
NarratableEntry,
Renderable {
    public static final int REDSTONE_MODE_IGNORED = 0;
    public static final int REDSTONE_MODE_UNPOWERED = 1;
    public static final int REDSTONE_MODE_POWERED = 2;
    private static final Component[] REDSTONE_MODES = new Component[]{Component.m_237115_((String)TranslationKeys.REDSTONE_CONTROL_MODES[0]).m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)TranslationKeys.REDSTONE_CONTROL_MODES[1]).m_130940_(ChatFormatting.GRAY), Component.m_237115_((String)TranslationKeys.REDSTONE_CONTROL_MODES[2]).m_130940_(ChatFormatting.WHITE)};
    private static final Component REDSTONE_CONTROL_LABEL = Component.m_237115_((String)"gui.exdeorum.redstone_control.label");
    private final AbstractMachineMenu<?> screen;
    private final ResourceLocation texture;
    private final int posX;
    private final int posY;
    private final int tabU;
    private final int tabV;
    private final int tabWidth;
    private final int tabHeight;
    private final int expandedV;
    private final int expandedU;
    private final int expandedWidth;
    private final int expandedHeight;
    private final int buttonsPosX;
    private final int buttonsPosY;
    private float percentage = 0.0f;
    private boolean expanded = false;
    private long lastClicked = -1L;

    public RedstoneControlWidget(AbstractMachineMenu<?> screen, ResourceLocation texture, int posX, int posY) {
        this.screen = screen;
        this.texture = texture;
        this.posX = posX;
        this.posY = posY;
        this.expandedU = 0;
        this.expandedV = 189;
        this.expandedWidth = 94;
        this.expandedHeight = 67;
        this.tabU = this.expandedWidth;
        this.tabV = 189;
        this.tabWidth = 26;
        this.tabHeight = 28;
        this.buttonsPosX = this.posX + 18;
        this.buttonsPosY = this.posY + 44;
    }

    public void m_88315_(GuiGraphics graphics, int mx, int my, float pPartialTick) {
        if (this.lastClicked != -1L) {
            this.percentage = (float)(System.currentTimeMillis() - this.lastClicked) / 200.0f;
            if (this.percentage >= 1.0f) {
                this.percentage = 0.0f;
                this.expanded = !this.expanded;
                this.lastClicked = -1L;
            } else {
                this.drawPartialConfig(graphics);
                return;
            }
        }
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.expanded) {
            int redstoneMode = ((AbstractMachineBlockEntity)((Object)this.screen.machine)).getRedstoneMode();
            graphics.m_280218_(this.texture, this.posX, this.posY, this.expandedU, this.expandedV, this.expandedWidth, this.expandedHeight);
            for (int i = 0; i < 3; ++i) {
                graphics.m_280218_(this.texture, this.buttonsPosX + i * 19, this.buttonsPosY, redstoneMode == i ? this.tabU + 16 : this.tabU, this.tabV + this.tabHeight, 16, 16);
            }
            graphics.m_280218_(this.texture, this.buttonsPosX, this.buttonsPosY, this.tabU, this.tabV + this.tabHeight + 16, 52, 14);
            graphics.m_280430_(font, (Component)Component.m_237115_((String)"gui.exdeorum.redstone_control.label"), this.posX + 16, this.posY + 10, 0xFFFFFF);
            graphics.m_280430_(font, (Component)Component.m_237115_((String)"gui.exdeorum.redstone_control.mode").m_7220_(REDSTONE_MODES[redstoneMode]), this.posX + 4, this.posY + 26, 0xFFFFFF);
        } else {
            graphics.m_280218_(this.texture, this.posX, this.posY, this.tabU, this.tabV, this.tabWidth, this.tabHeight);
            if (this.posX <= mx && mx < this.posX + this.tabWidth && this.posY <= my && my < this.posY + this.tabHeight) {
                graphics.m_280557_(font, REDSTONE_CONTROL_LABEL, mx, my);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        float percentage;
        int mx = (int)mouseX;
        int my = (int)mouseY;
        int rx = mx - this.posX;
        int ry = my - this.posY;
        float f = percentage = this.expanded ? 1.0f - this.percentage : this.percentage;
        if (0 <= rx && rx < this.getWidth(percentage) && 0 <= ry && ry < this.getHeight(percentage)) {
            if (this.expanded && this.buttonsPosY <= my && my < this.buttonsPosY + 16) {
                for (int i = 0; i < 3; ++i) {
                    int buttonStartX = this.buttonsPosX + i * 19;
                    if (buttonStartX > mx || mx >= buttonStartX + 16) continue;
                    this.setRedstoneMode(i);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.05f));
                    return true;
                }
            }
            if (this.lastClicked == -1L && rx < this.tabWidth && ry < this.tabHeight) {
                this.lastClicked = System.currentTimeMillis();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        return false;
    }

    private void setRedstoneMode(int redstoneMode) {
        this.screen.m_6366_((Player)Minecraft.m_91087_().f_91074_, redstoneMode);
        Minecraft.m_91087_().f_91072_.m_105208_(this.screen.f_38840_, redstoneMode);
    }

    private void drawPartialConfig(GuiGraphics graphics) {
        float percentage = this.expanded ? 1.0f - this.percentage : this.percentage;
        int width = this.getWidth(percentage) - 3;
        int height = this.getHeight(percentage) - 3;
        int edgeU = this.expandedU + this.expandedWidth - 3;
        int edgeV = this.expandedV + this.expandedHeight - 3;
        graphics.m_280218_(this.texture, this.posX, this.posY, this.expandedU, this.expandedV, width, height);
        graphics.m_280218_(this.texture, this.posX, this.posY + height, this.expandedU, edgeV, width, 3);
        graphics.m_280218_(this.texture, this.posX + width, this.posY, edgeU, this.expandedV, 3, height);
        graphics.m_280218_(this.texture, this.posX + width, this.posY + height, edgeU, edgeV, 3, 3);
    }

    public int getWidth(float percentage) {
        return this.tabWidth + Math.round((float)(this.expandedWidth - this.tabWidth) * percentage);
    }

    public int getHeight(float percentage) {
        return this.tabHeight + Math.round((float)(this.expandedHeight - this.tabHeight) * percentage);
    }

    public void m_93692_(boolean pFocused) {
    }

    public boolean m_93696_() {
        return false;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narration) {
    }

    public List<Rect2i> getJeiBounds() {
        float percentage = this.expanded ? 1.0f - this.percentage : this.percentage;
        return List.of(new Rect2i(this.posX, this.posY, this.getWidth(percentage), this.getHeight(percentage)));
    }
}

