/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import thedarkcolour.exdeorum.ExDeorum;

public class CompostColors {
    public static final String VANILLA_COMPOST_COLORS_FILE = "vanilla_compost_colors.txt";
    public static final Path COMPOST_COLORS_CONFIGS = Paths.get("config/exdeorum/compost_colors", new String[0]);
    public static final Object2ObjectOpenHashMap<Item, Vector3i> COLORS = new Object2ObjectOpenHashMap();
    public static final Vector3i DEFAULT_COLOR = new Vector3i(53, 168, 42);

    public static void loadColors() {
        COLORS.clear();
        CompostColors.loadVanilla();
        CompostColors.loadModded();
    }

    public static boolean isLoaded() {
        return !COLORS.isEmpty();
    }

    private static void loadVanilla() {
        Path vanillaColors = ModList.get().getModFileById("exdeorum").getFile().findResource(new String[]{VANILLA_COMPOST_COLORS_FILE});
        if (!Files.exists(vanillaColors, new LinkOption[0])) {
            if (ExDeorum.DEBUG) {
                CompostColors.debugCompute();
                CompostColors.export("minecraft");
            } else {
                ExDeorum.LOGGER.error("Failed to load vanilla colors!");
            }
        } else {
            CompostColors.readColorFile("minecraft", vanillaColors);
        }
    }

    private static void debugCompute() {
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        int atlasWidth = atlas.f_276067_;
        int atlasHeight = atlas.f_276070_;
        try (NativeImage image = new NativeImage(atlasWidth, atlasHeight, false);){
            GlStateManager._bindTexture((int)atlas.m_117963_());
            image.m_85045_(0, false);
            for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
                TextureAtlasSprite sprite;
                Item item = (Item)entry.getValue();
                BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(item);
                if (model == null || !(sprite = model.getParticleIcon(ModelData.EMPTY)).m_247685_().equals((Object)InventoryMenu.f_39692_)) continue;
                int width = sprite.m_245424_().m_246492_();
                int height = sprite.m_245424_().m_245330_();
                int pixels = 0;
                int totalR = 0;
                int totalG = 0;
                int totalB = 0;
                for (int i = sprite.f_118349_; i < sprite.f_118349_ + width; ++i) {
                    for (int j = sprite.f_118350_; j < sprite.f_118350_ + height; ++j) {
                        int pixel = image.m_84985_(i, j);
                        if (pixel == 0) continue;
                        totalB += pixel >> 16 & 0xFF;
                        totalG += pixel >> 8 & 0xFF;
                        totalR += pixel & 0xFF;
                        ++pixels;
                    }
                }
                CompostColors.putColor(pixels, totalR, totalG, totalB, item);
            }
        }
    }

    private static void loadModded() {
        ObjectSet<String> readMods = CompostColors.readModdedColorFiles();
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            Path texturePath;
            JsonObject textureMap;
            String texture;
            JsonElement textures;
            JsonObject modelJson;
            String modid = ((ResourceKey)entry.getKey()).m_135782_().m_135827_();
            if (readMods.contains((Object)modid)) continue;
            String id = ((ResourceKey)entry.getKey()).m_135782_().m_135815_();
            IModFileInfo modFile = ModList.get().getModFileById(modid);
            if (modFile == null) continue;
            IModFile jarFile = modFile.getFile();
            Path modelPath = jarFile.findResource(new String[]{"assets/" + modid + "/models/item/" + id + ".json"});
            if (!Files.exists(modelPath, new LinkOption[0]) || (modelJson = CompostColors.parseModelJson(modelPath, modid, id)) == null || !((textures = modelJson.get("textures")) instanceof JsonObject) || (texture = CompostColors.findFirstTexture(textureMap = (JsonObject)textures)) == null || !Files.exists(texturePath = jarFile.findResource(new String[]{"assets/" + modid + "/textures/" + texture + ".png"}), new LinkOption[0])) continue;
            try {
                InputStream stream = Files.newInputStream(texturePath, new OpenOption[0]);
                try {
                    BufferedImage img = ImageIO.read(stream);
                    int width = img.getWidth();
                    int height = img.getHeight();
                    int pixels = 0;
                    int totalR = 0;
                    int totalG = 0;
                    int totalB = 0;
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            int pixel = img.getRGB(x, y);
                            if (pixel == 0) continue;
                            totalR += pixel >> 16 & 0xFF;
                            totalG += pixel >> 8 & 0xFF;
                            totalB += pixel & 0xFF;
                            ++pixels;
                        }
                    }
                    CompostColors.putColor(pixels, totalR, totalG, totalB, (Item)entry.getValue());
                    if (!ExDeorum.DEBUG) continue;
                    ExDeorum.LOGGER.debug("Item {}:{} has color {}", new Object[]{modid, id, COLORS.get(entry.getValue())});
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException exception) {
                ExDeorum.LOGGER.error("Failed to read texture file for item {}:{}", (Object)modid, (Object)id);
            }
        }
        Map<String, List<Item>> entries = COLORS.keySet().stream().sorted(Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0))).collect(Collectors.groupingBy(item -> ForgeRegistries.ITEMS.getKey(item).m_135827_()));
        for (Map.Entry<String, List<Item>> entry : entries.entrySet()) {
            if (readMods.contains((Object)entry.getKey())) continue;
            CompostColors.export(entry.getKey(), entry.getValue());
        }
    }

    @Nullable
    private static String findFirstTexture(JsonObject textureMap) {
        JsonElement jsonElement = textureMap.get("layer0");
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            return new ResourceLocation(primitive.getAsString()).m_135815_();
        }
        return null;
    }

    private static ObjectSet<String> readModdedColorFiles() {
        String[] children;
        File colorsFolder = COMPOST_COLORS_CONFIGS.toFile();
        ObjectOpenHashSet readMods = new ObjectOpenHashSet();
        readMods.add((Object)"minecraft");
        if (colorsFolder.exists() && colorsFolder.isDirectory() && (children = colorsFolder.list()) != null) {
            for (String child : children) {
                if (!child.endsWith(".txt")) continue;
                String modid = child.replace(".txt", "");
                if (!ModList.get().isLoaded(modid) || modid.equals("minecraft") || !CompostColors.readColorFile(modid, COMPOST_COLORS_CONFIGS.resolve(child))) continue;
                readMods.add((Object)modid);
            }
        }
        return readMods;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonObject parseModelJson(Path modelPath, String modid, String id) {
        block16: {
            try (InputStream stream = Files.newInputStream(modelPath, new OpenOption[0]);){
                try (InputStreamReader streamReader = new InputStreamReader(stream);){
                    JsonObject jsonObject = GsonHelper.m_13864_((String)IOUtils.toString((Reader)streamReader));
                    return jsonObject;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            catch (IOException exception) {
                ExDeorum.LOGGER.error("Failed to read model file for item {}:{}", (Object)modid, (Object)id);
            }
        }
        return null;
    }

    private static void putColor(int pixels, int totalR, int totalG, int totalB, Item item) {
        if (pixels > 0 && (totalR | totalG | totalB) != 0) {
            int tint = CompostColors.getTint(item);
            Color c = tint == 0 ? new Color(totalR / pixels, totalG / pixels, totalB / pixels).brighter() : new Color((float)totalR / (float)pixels / 255.0f * ((float)(tint >> 16 & 0xFF) / 255.0f), (float)totalG / (float)pixels / 255.0f * ((float)(tint >> 8 & 0xFF) / 255.0f), (float)totalB / (float)pixels / 255.0f * ((float)(tint & 0xFF) / 255.0f));
            Vector3i color = new Vector3i(c.getRed(), c.getGreen(), c.getBlue());
            COLORS.put((Object)item, (Object)color);
        }
    }

    private static int getTint(Item item) {
        if (ExDeorum.DEBUG && FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.m_91087_().getItemColors().m_92676_(new ItemStack((ItemLike)item), 0);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private static boolean readColorFile(String modid, Path path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void export(String modid) {
        CompostColors.export(modid, COLORS.keySet().stream().filter(key -> ForgeRegistries.ITEMS.getKey(key).m_135827_().equals(modid)).sorted(Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0))).toList());
    }

    private static void export(String modid, List<Item> sortedToExport) {
        try {
            Path path;
            File file;
            if (CompostColors.createConfigFolder(COMPOST_COLORS_CONFIGS) && ((file = (path = COMPOST_COLORS_CONFIGS.resolve(modid + ".txt")).toFile()).exists() && file.delete() || file.createNewFile())) {
                try (FileWriter fileWriter = new FileWriter(file);){
                    try (BufferedWriter writer = new BufferedWriter(fileWriter);){
                        ArrayList<Item> alphabeticalItems = new ArrayList<Item>(sortedToExport);
                        alphabeticalItems.sort(Comparator.comparing(item -> ForgeRegistries.ITEMS.getKey(item).m_135815_()));
                        writer.write("// Compost colors for " + modid + ". You may add your own colors, change existing ones, or remove colors that aren't needed.\n");
                        for (Item item2 : alphabeticalItems) {
                            if (!COLORS.containsKey((Object)item2)) continue;
                            writer.write(ForgeRegistries.ITEMS.getKey((Object)item2).m_135815_());
                            writer.write(", #");
                            Vector3i colorVec = (Vector3i)COLORS.get((Object)item2);
                            writer.write(Integer.toHexString(new Color(colorVec.x, colorVec.y, colorVec.z).getRGB() & 0xFFFFFF));
                            writer.write(10);
                        }
                    }
                    return;
                }
            }
            ExDeorum.LOGGER.error("Unable to save compost colors for mod \"{}\"", (Object)modid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean createConfigFolder(Path configPath) {
        File colorsFolder = configPath.toFile();
        File configFolder = configPath.getParent().toFile();
        return !(!configFolder.exists() && !configFolder.mkdir() || !colorsFolder.exists() && !colorsFolder.mkdir());
    }
}

