/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.MechanicalHammerBlock;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.MechanicalHammerMenu;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.loot.HammerLootModifier;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.tag.EItemTags;

public class MechanicalHammerBlockEntity
extends AbstractMachineBlockEntity<MechanicalHammerBlockEntity> {
    private static final Component TITLE = Component.m_237115_((String)"exdeorum.container.mechanical_hammer");
    private static final int INPUT_SLOT = 0;
    public static final int HAMMER_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    public static final int TOTAL_PROGRESS = 10000000;
    private static final int PROGRESS_INTERVAL = 50000;
    public static final int NOT_RUNNING = -1;
    private int progress = -1;
    private float efficiency;

    public MechanicalHammerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.MECHANICAL_HAMMER.get(), pos, state, ItemHandler::new, (Integer)EConfig.SERVER.mechanicalHammerEnergyStorage.get());
    }

    public static boolean isValidInput(ItemStack stack) {
        return RecipeUtil.getHammerRecipe(stack.m_41720_()) != null;
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("progress", this.progress);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("progress");
        this.onHammerChanged();
    }

    public Component m_5446_() {
        return TITLE;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player pPlayer) {
        return new MechanicalHammerMenu(containerId, playerInventory, this);
    }

    @Override
    protected boolean isRunning() {
        return this.progress != -1;
    }

    @Override
    protected void tryStartRunning() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (!input.m_41619_() && this.canFitResultIntoOutput(input) != null) {
            this.progress = 0;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(true)), 3);
            return;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)MechanicalHammerBlock.RUNNING)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    protected void noEnergyTick() {
        if (((Boolean)this.m_58900_().m_61143_((Property)MechanicalHammerBlock.RUNNING)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Nullable
    private HammerRecipe canFitResultIntoOutput(ItemStack input) {
        HammerRecipe recipe;
        ItemStack output = this.inventory.getStackInSlot(2);
        if ((output.m_41619_() || output.m_41613_() < output.m_41741_()) && (recipe = RecipeUtil.getHammerRecipe(input.m_41720_())) != null && (output.m_41619_() || MechanicalHammerBlockEntity.matchesStack(recipe.result, recipe.getRawResultNbt(), output))) {
            return recipe;
        }
        return null;
    }

    private static boolean matchesStack(Item item, @Nullable CompoundTag itemNbt, ItemStack stack) {
        return Objects.equals(itemNbt, stack.m_41783_()) && item == stack.m_41720_();
    }

    @Override
    protected void runMachineTick() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (!input.m_41619_()) {
            this.progress += (int)(50000.0f * this.efficiency);
            if (this.progress >= 10000000) {
                HammerRecipe recipe = this.canFitResultIntoOutput(input);
                if (recipe != null) {
                    LootContext ctx = RecipeUtil.emptyLootContext((ServerLevel)this.f_58857_);
                    int resultCount = recipe.resultAmount.m_142683_(ctx);
                    resultCount += HammerLootModifier.calculateFortuneBonus(this.inventory.getStackInSlot(1), ctx.m_230907_(), resultCount == 0);
                    ItemStack output = this.inventory.getStackInSlot(2);
                    if (output.m_41619_()) {
                        ItemStack stack = new ItemStack((ItemLike)recipe.result, resultCount);
                        stack.m_41751_(recipe.getResultNbt());
                        this.inventory.setStackInSlot(2, stack);
                    } else {
                        output.m_41764_(Math.min(output.m_41741_(), resultCount + output.m_41613_()));
                    }
                    input.m_41774_(1);
                    this.damageHammer(ctx.m_230907_());
                    this.m_6596_();
                }
                this.progress = -1;
            }
        } else {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private void damageHammer(RandomSource rand) {
        ItemStack hammer = this.inventory.getStackInSlot(1);
        if (hammer.m_41763_() && hammer.m_220157_(1, rand, null)) {
            hammer.m_41774_(1);
            if (hammer.m_41619_()) {
                this.inventory.setStackInSlot(1, ItemStack.f_41583_);
            }
        }
    }

    private void onHammerChanged() {
        ItemStack hammer = this.inventory.getStackInSlot(1);
        this.efficiency = hammer.m_41619_() ? 1.0f : 2.0f + (float)hammer.getEnchantmentLevel(Enchantments.f_44984_) * 0.33f;
    }

    @Override
    protected int getEnergyConsumption() {
        return (Integer)EConfig.SERVER.mechanicalHammerEnergyConsumption.get();
    }

    public int getGuiProgress() {
        return Math.round((float)(24 * this.progress) / 1.0E7f);
    }

    public void setGuiProgress(int guiProgress) {
        this.progress = guiProgress * 10000000 / 24;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    private static class ItemHandler
    extends ItemHelper {
        private final MechanicalHammerBlockEntity hammer;

        public ItemHandler(MechanicalHammerBlockEntity hammer) {
            super(3);
            this.hammer = hammer;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return RecipeUtil.getHammerRecipe(stack.m_41720_()) != null;
            }
            if (slot == 1) {
                return stack.m_204117_(EItemTags.HAMMERS);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        public boolean canMachineExtract(int slot) {
            return slot == 2;
        }

        protected void onContentsChanged(int slot) {
            if (slot == 1) {
                this.hammer.onHammerChanged();
            } else if (slot == 0 && this.getStackInSlot(0).m_41619_()) {
                this.hammer.progress = -1;
            }
        }
    }
}

