/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.EBlock;
import thedarkcolour.exdeorum.block.ETankBlock;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.registry.EBlockEntities;

public class BarrelBlock
extends ETankBlock {
    public static final float BARREL_FLUID_BOTTOM = 0.0625f;
    public static final float BARREL_FLUID_TOP = 0.875f;
    public static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)BarrelBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)BarrelBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);

    public BarrelBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<? extends BlockEntityType<?>>)EBlockEntities.BARREL);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState pState, BlockEntityType<T> type) {
        return type == EBlockEntities.BARREL.get() ? new BarrelBlockEntity.Ticker() : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BarrelBlockEntity barrel;
        ItemStack item;
        BlockEntity blockEntity;
        if (!level.f_46443_ && !state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof BarrelBlockEntity && !(item = (barrel = (BarrelBlockEntity)blockEntity).getItem()).m_41619_()) {
            EBlock.dropItem(level, pos, item);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(BlockState pState, Level level, BlockPos pos, Block pBlock, BlockPos fromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (fromPos.m_123342_() - pos.m_123342_() == 1) {
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity2;
                barrel.tryInWorldFluidMixing();
            }
        } else if (fromPos.m_123342_() - pos.m_123342_() == -1 && (blockEntity = level.m_7702_(pos)) instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            barrel.updateFluidTransform();
        }
    }

    @Override
    protected boolean isEntityInFluid(Level level, BlockPos pos, Entity entity, float fillRatio) {
        float fluidTop = Mth.m_14179_((float)fillRatio, (float)0.0625f, (float)0.875f);
        return entity.m_20191_().m_82314_((double)pos.m_123341_() + 0.125, (double)((float)pos.m_123342_() + 0.0625f), (double)pos.m_123343_() + 0.125, (double)pos.m_123341_() + 0.875, (double)((float)pos.m_123342_() + fluidTop), (double)pos.m_123343_() + 0.875);
    }
}

