/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network.packets;

import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.network.ClientToServerPacket;
import com.github.almostreliable.energymeter.util.TypeEnums;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class AccuracyUpdatePacket
extends ClientToServerPacket<AccuracyUpdatePacket> {
    private TypeEnums.TEXT_BOX identifier;
    private int value;

    public AccuracyUpdatePacket(TypeEnums.TEXT_BOX identifier, int value) {
        this.identifier = identifier;
        this.value = value;
    }

    public AccuracyUpdatePacket() {
    }

    @Override
    public void encode(AccuracyUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.identifier.ordinal());
        buffer.writeInt(packet.value);
    }

    @Override
    public AccuracyUpdatePacket decode(FriendlyByteBuf buffer) {
        return new AccuracyUpdatePacket(TypeEnums.TEXT_BOX.values()[buffer.readInt()], buffer.readInt());
    }

    @Override
    public void handlePacket(AccuracyUpdatePacket packet, @Nullable ServerPlayer player) {
        if (player != null && player.f_36096_ instanceof MeterContainer) {
            MeterEntity entity = ((MeterContainer)player.f_36096_).getEntity();
            Level level = entity.m_58904_();
            if (level == null || !level.m_46749_(entity.m_58899_())) {
                return;
            }
            if (packet.identifier == TypeEnums.TEXT_BOX.INTERVAL) {
                entity.setInterval(packet.value);
                entity.syncData(64);
            } else if (packet.identifier == TypeEnums.TEXT_BOX.THRESHOLD) {
                entity.setThreshold(packet.value);
                entity.syncData(128);
            }
            entity.m_6596_();
        }
    }
}

