/*
 * Decompiled with CFR 0.152.
 */
package dev.nanite.dsp.mixin;

import dev.nanite.dsp.DSPExpectedPlatform;
import dev.nanite.dsp.DSPMod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DedicatedServerProperties.class})
public abstract class DedicatedServerPropertiesMixin {
    @Inject(at={@At(value="HEAD")}, method={"fromFile(Ljava/nio/file/Path;)Lnet/minecraft/server/dedicated/DedicatedServerProperties;"}, cancellable=true)
    private static void fromFile(Path path, CallbackInfoReturnable<DedicatedServerProperties> info) {
        Path defaultSettingPath = DSPExpectedPlatform.getGameDir().resolve("default-server.properties");
        if (!Files.exists(defaultSettingPath, new LinkOption[0])) {
            DSPMod.LOGGER.info("No default-server.properties exist in the games root path... ignoring default injection");
            return;
        }
        Path localMarkerFile = DSPExpectedPlatform.getGameDir().resolve("local/default-used.marker");
        if (Files.exists(localMarkerFile, new LinkOption[0])) {
            DSPMod.LOGGER.info("Default server properties injection ignored as it has already been run. This is not an error. This is correct behaviour.");
            return;
        }
        if (Files.notExists(localMarkerFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(localMarkerFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                DSPMod.LOGGER.error("Failed to create local dir in the games root path...", (Throwable)e);
                return;
            }
        }
        try {
            Files.writeString(localMarkerFile, (CharSequence)"", new OpenOption[0]);
        }
        catch (IOException e) {
            DSPMod.LOGGER.error("Unable to create marker so avoiding default properties injection...", (Throwable)e);
            return;
        }
        DedicatedServerProperties dedicatedServerProperties = new DedicatedServerProperties(DedicatedServerProperties.m_139839_((Path)defaultSettingPath));
        DSPMod.LOGGER.info("Replacing server properties with default properties!");
        info.setReturnValue((Object)dedicatedServerProperties);
    }
}

