/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.client.DankKeybinds;
import tfar.dankstorage.client.DankTooltip;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.menu.PortableDankProvider;
import tfar.dankstorage.mixin.ItemUsageContextAccessor;
import tfar.dankstorage.network.client.S2CSyncSelectedDankItemPacket;
import tfar.dankstorage.network.server.C2SRequestContentsPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.UseType;
import tfar.dankstorage.world.ClientData;
import tfar.dankstorage.world.MaxId;

public class CDankItem
extends Item {
    public final DankStats stats;
    private static final ThreadLocal<Integer> cache = ThreadLocal.withInitial(() -> -1);

    public CDankItem(Item.Properties $$0, DankStats stats) {
        super($$0);
        this.stats = stats;
    }

    public void m_7373_(ItemStack bag, @javax.annotation.Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (bag.m_41782_() && Services.PLATFORM.isDevelopmentEnvironment()) {
            String s = bag.m_41783_().toString();
            ArrayList<String> bits = new ArrayList<String>();
            int length = s.length();
            if (s.length() > 10000) {
                return;
            }
            int itr = (int)Math.ceil((double)length / 40.0);
            for (int i = 0; i < itr; ++i) {
                int end = (i + 1) * 40;
                if ((i + 1) * 40 - 1 >= length) {
                    end = length;
                }
                String s12 = s.substring(i * 40, end);
                bits.add(s12);
            }
            bits.forEach(s1 -> tooltip.add((Component)CommonUtils.literal(s1)));
        }
        int id = CommonUtils.getFrequency(bag);
        tooltip.add((Component)CommonUtils.literal("ID: " + id));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.shift", CommonUtils.literal("Shift").m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.change_pickup_mode", DankKeybinds.PICKUP_MODE.m_90863_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            PickupMode pickupMode = CommonUtils.getPickupMode(bag);
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.current_pickup_mode", pickupMode.translate().m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.changeusetype", DankKeybinds.CONSTRUCTION.m_90863_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            UseType useType = CommonUtils.getUseType(bag);
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.currentusetype", CommonUtils.translatable("dankstorage.usetype." + useType.name().toLowerCase(Locale.ROOT)).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.stacklimit", CommonUtils.literal("" + this.stats.stacklimit).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResult m_6880_(ItemStack bag, Player player, LivingEntity entity, InteractionHand hand) {
        if (!CommonUtils.isConstruction(bag)) {
            return InteractionResult.PASS;
        }
        ItemStack toUse = CommonUtils.getSelectedItem(bag, player.m_9236_());
        if (toUse.m_41619_()) {
            return InteractionResult.PASS;
        }
        player.m_21008_(hand, toUse);
        InteractionResult result = toUse.m_41720_().m_6880_(toUse, player, entity, hand);
        if (!player.m_9236_().f_46443_) {
            DankInterface handler = CommonUtils.getBagInventory(bag, player.m_9236_());
            handler.setItemDank(CommonUtils.getSelectedSlot(bag), toUse);
        }
        player.m_21008_(hand, bag);
        return result;
    }

    public boolean m_41386_(DamageSource source) {
        return !source.m_269533_(DamageTypeTags.f_268738_);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && CommonUtils.getPickupMode(stack) != PickupMode.none;
    }

    public MenuProvider createProvider(ItemStack stack) {
        return new PortableDankProvider(stack);
    }

    public int getGlintColor(ItemStack stack) {
        PickupMode pickupMode = CommonUtils.getPickupMode(stack);
        switch (pickupMode) {
            default: {
                return -1;
            }
            case pickup_all: {
                return -16711936;
            }
            case filtered_pickup: {
                return -256;
            }
            case void_pickup: 
        }
        return -65536;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack bag = ctx.m_43722_();
        Level level = ctx.m_43725_();
        UseType useType = CommonUtils.getUseType(bag);
        if (useType == UseType.bag) {
            return InteractionResult.PASS;
        }
        int selectedSlot = CommonUtils.getSelectedSlot(bag);
        if (selectedSlot == -1) {
            return InteractionResult.PASS;
        }
        ItemStack toPlace = CommonUtils.getSelectedItem(bag, level);
        UseOnContext2 ctx2 = new UseOnContext2(ctx.m_43725_(), ctx.m_43723_(), ctx.m_43724_(), toPlace, ((ItemUsageContextAccessor)ctx).getHitResult());
        InteractionResult actionResultType = toPlace.m_41720_().m_6225_((UseOnContext)ctx2);
        if (!level.f_46443_) {
            DankInterface dankInventory = CommonUtils.getBagInventory(bag, level);
            dankInventory.setItemDank(selectedSlot, ctx2.m_43722_());
        }
        return actionResultType;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack bag = player.m_21120_(hand);
        if (CommonUtils.getUseType(bag) == UseType.bag) {
            if (!level.f_46443_) {
                CDankItem.assignNextId(bag);
                player.m_5893_(this.createProvider(bag));
            }
            return InteractionResultHolder.m_19090_((Object)bag);
        }
        if (!level.f_46443_) {
            EquipmentSlot hand1;
            ItemStack toPlace = CommonUtils.getItemStackInSelectedSlot(bag, (ServerLevel)level);
            EquipmentSlot equipmentSlot = hand1 = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            if (toPlace.m_41619_()) {
                return InteractionResultHolder.m_19098_((Object)bag);
            }
            if (toPlace.m_41720_().m_41472_()) {
                if (player.m_36391_(false)) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19096_((Object)bag);
                }
            } else {
                if (toPlace.m_41720_() instanceof PotionItem) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
                }
                if (toPlace.m_41720_() instanceof ShieldItem) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
                }
                ItemStack bagCopy = bag.m_41777_();
                player.m_8061_(hand1, toPlace);
                InteractionResultHolder actionResult = toPlace.m_41720_().m_7203_(level, player, hand);
                DankInterface handler = CommonUtils.getBagInventory(bagCopy, level);
                handler.setItemDank(CommonUtils.getSelectedSlot(bagCopy), (ItemStack)actionResult.m_19095_());
                player.m_8061_(hand1, bagCopy);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        int id = CommonUtils.getFrequency(itemStack);
        if (id > -1) {
            if (cache.get() == id) {
                // empty if block
            }
            C2SRequestContentsPacket.send(id);
            cache.set(id);
            if (ClientData.cachedItems != null) {
                NonNullList nonNullList = NonNullList.m_122779_();
                nonNullList.addAll(ClientData.cachedItems);
                return Optional.of(new DankTooltip((NonNullList<ItemStack>)nonNullList, CommonUtils.getSelectedSlot(itemStack)));
            }
        }
        return Optional.empty();
    }

    public static void assignNextId(ItemStack dank) {
        CompoundTag settings = CommonUtils.getSettings(dank);
        if (settings == null || !settings.m_128425_("dankstorage:frequency", 3)) {
            MaxId maxId = DankStorage.maxId;
            int next = maxId.getMaxId();
            maxId.increment();
            CommonUtils.getOrCreateSettings(dank).m_128405_("dankstorage:frequency", next);
        }
    }

    public void m_6883_(ItemStack bag, Level level, Entity entity, int i, boolean equipped) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (equipped) {
                ItemStack sel = CommonUtils.getSelectedItem(bag, level);
                Services.PLATFORM.sendToClient(new S2CSyncSelectedDankItemPacket(sel), player);
            }
        }
    }

    static class UseOnContext2
    extends UseOnContext {
        protected UseOnContext2(Level $$0, @Nullable Player $$1, InteractionHand $$2, ItemStack $$3, BlockHitResult $$4) {
            super($$0, $$1, $$2, $$3, $$4);
        }
    }
}

