/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public abstract class ConnectionMixin {
    @Shadow
    @Nullable
    private volatile PacketListener f_129470_;
    @Unique
    private int counter = 0;

    @Shadow
    public abstract void m_129507_(Component var1);

    @Inject(method={"exceptionCaught"}, at={@At(value="HEAD")})
    public void on(ChannelHandlerContext context, Throwable throwable, CallbackInfo ci) {
        ++this.counter;
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages && !(throwable instanceof ClosedChannelException)) {
            PacketListener packetListener = this.f_129470_;
            if (packetListener instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl serverGamePacketListener = (ServerGamePacketListenerImpl)packetListener;
                Connectivity.LOGGER.warn("Network error in:" + context.name() + " for player:" + serverGamePacketListener.m_142253_().m_7755_().getString(), throwable);
            } else {
                Connectivity.LOGGER.warn("Network error in:" + context.name() + " with:" + this.f_129470_, throwable);
            }
        }
        if (this.counter >= 20) {
            this.counter = -100000;
            this.m_129507_((Component)Component.m_237113_((String)"Too many network errors"));
            context.channel().disconnect().addListener(future -> {
                if (!future.isSuccess() && ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                    Connectivity.LOGGER.warn("Failed to disconnect channel: " + context.channel().remoteAddress());
                }
                context.channel().deregister().addListener(dereFuture -> {
                    if (dereFuture.isSuccess()) {
                        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                            Connectivity.LOGGER.warn("Channel deregistered: " + context.channel().remoteAddress());
                        }
                    } else if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                        Connectivity.LOGGER.warn("Failed to deregister channel: " + context.channel().remoteAddress());
                    }
                    context.channel().close().addListener(closeFuture -> {
                        if (closeFuture.isSuccess()) {
                            if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                                Connectivity.LOGGER.warn("Channel closed: " + context.channel().remoteAddress());
                            }
                        } else if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                            Connectivity.LOGGER.warn("Failed to close channel: " + context.channel().remoteAddress());
                        }
                        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                            Connectivity.LOGGER.warn("Removing Handlers");
                        }
                        for (String name : context.channel().pipeline().names()) {
                            context.channel().pipeline().remove(name);
                        }
                    });
                });
            });
        }
    }

    @Redirect(method={"disconnect"}, at=@At(value="INVOKE", target="Lio/netty/channel/ChannelFuture;awaitUninterruptibly()Lio/netty/channel/ChannelFuture;"))
    private ChannelFuture onWait(ChannelFuture instance) {
        try {
            instance.await(10L, TimeUnit.SECONDS);
            return null;
        }
        catch (InterruptedException e) {
            Connectivity.LOGGER.warn("Interrupted thread:" + Thread.currentThread());
            return null;
        }
    }
}

