/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.FriendlyByteBuf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CompressionDecoder.class}, priority=99)
public abstract class CompressionDecoderMixin
extends ByteToMessageDecoder {
    @Shadow
    private int f_129435_;
    @Shadow
    private boolean f_182673_;
    @Unique
    private int size = 0;
    @Unique
    private boolean originalValidate = false;

    @Inject(method={"decode"}, at={@At(value="HEAD")})
    private void disabledLimit(ChannelHandlerContext p_129441_, ByteBuf p_129442_, List<Object> p_129443_, CallbackInfo ci) {
        this.originalValidate = this.f_182673_;
        this.f_182673_ = false;
    }

    @Inject(method={"decode"}, at={@At(value="RETURN")})
    private void restoreLimit(ChannelHandlerContext p_129441_, ByteBuf p_129442_, List<Object> p_129443_, CallbackInfo ci) {
        this.f_182673_ = this.originalValidate;
    }

    @Redirect(method={"decode"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/FriendlyByteBuf;readVarInt()I"))
    private int saveSize(FriendlyByteBuf instance) {
        this.size = instance.m_130242_();
        return this.size;
    }

    @Inject(method={"decode"}, at={@At(value="RETURN")})
    private void checkSize(ChannelHandlerContext p_129441_, ByteBuf p_129442_, List<Object> list, CallbackInfo ci) {
        if (this.size < this.f_129435_ && !((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
            this.printDebug(list);
            throw new DecoderException("Badly compressed packet - size of " + this.size + " is below server threshold of " + this.f_129435_);
        }
        if (this.size > 0x800000 && !((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
            this.printDebug(list);
            throw new DecoderException("Badly compressed packet - size of " + this.size + " is larger than protocol maximum of 8388608");
        }
        this.size = 0;
    }

    @Unique
    private void printDebug(List<Object> decodingResults) {
        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            return;
        }
        Connectivity.LOGGER.error("Received large message, debug print below!");
        Connectivity.LOGGER.error("----BEGIND PRINTING PACKET-----");
        for (int i = 0; i < decodingResults.size(); ++i) {
            ByteBuf buf = (ByteBuf)decodingResults.get(i);
            if (buf == null) continue;
            Connectivity.LOGGER.error("Data:");
            boolean prev = ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages;
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = true;
            PacketLogging.logPacket(buf);
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = prev;
            buf.resetReaderIndex();
        }
        Connectivity.LOGGER.error("----END PRINTING PACKET-----");
    }
}

