/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.pocket.PocketUpgradeDataProvider;
import dan200.computercraft.api.turtle.TurtleUpgradeDataProvider;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.arguments.ComputerSelector;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class LanguageProvider
implements DataProvider {
    private final PackOutput output;
    private final TurtleUpgradeDataProvider turtleUpgrades;
    private final PocketUpgradeDataProvider pocketUpgrades;
    private final Map<String, String> translations = new HashMap<String, String>();

    public LanguageProvider(PackOutput output, TurtleUpgradeDataProvider turtleUpgrades, PocketUpgradeDataProvider pocketUpgrades) {
        this.output = output;
        this.turtleUpgrades = turtleUpgrades;
        this.pocketUpgrades = pocketUpgrades;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        this.addTranslations();
        this.getExpectedKeys().forEach(x -> {
            if (!this.translations.containsKey(x)) {
                throw new IllegalStateException("No translation for " + x);
            }
        });
        JsonObject json = new JsonObject();
        for (Map.Entry<String, String> pair : this.translations.entrySet()) {
            json.addProperty(pair.getKey(), pair.getValue());
        }
        return DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)json, (Path)this.output.m_245114_().resolve("assets/computercraft/lang/en_us.json"));
    }

    public String m_6055_() {
        return "Languages";
    }

    private void addTranslations() {
        this.add("itemGroup.computercraft", "ComputerCraft");
        this.add((Item)ModRegistry.Items.COMPUTER_NORMAL.get(), "Computer");
        this.add((Item)ModRegistry.Items.COMPUTER_ADVANCED.get(), "Advanced Computer");
        this.add((Item)ModRegistry.Items.COMPUTER_COMMAND.get(), "Command Computer");
        this.add((Item)ModRegistry.Items.DISK_DRIVE.get(), "Disk Drive");
        this.add((Item)ModRegistry.Items.PRINTER.get(), "Printer");
        this.add((Item)ModRegistry.Items.SPEAKER.get(), "Speaker");
        this.add((Item)ModRegistry.Items.MONITOR_NORMAL.get(), "Monitor");
        this.add((Item)ModRegistry.Items.MONITOR_ADVANCED.get(), "Advanced Monitor");
        this.add((Item)ModRegistry.Items.WIRELESS_MODEM_NORMAL.get(), "Wireless Modem");
        this.add((Item)ModRegistry.Items.WIRELESS_MODEM_ADVANCED.get(), "Ender Modem");
        this.add((Item)ModRegistry.Items.WIRED_MODEM.get(), "Wired Modem");
        this.add((Item)ModRegistry.Items.CABLE.get(), "Networking Cable");
        this.add((Item)ModRegistry.Items.WIRED_MODEM_FULL.get(), "Wired Modem");
        this.add((Item)ModRegistry.Items.TURTLE_NORMAL.get(), "Turtle");
        this.add(((TurtleBlock)ModRegistry.Blocks.TURTLE_NORMAL.get()).m_7705_() + ".upgraded", "%s Turtle");
        this.add(((TurtleBlock)ModRegistry.Blocks.TURTLE_NORMAL.get()).m_7705_() + ".upgraded_twice", "%s %s Turtle");
        this.add((Item)ModRegistry.Items.TURTLE_ADVANCED.get(), "Advanced Turtle");
        this.add(((TurtleBlock)ModRegistry.Blocks.TURTLE_ADVANCED.get()).m_7705_() + ".upgraded", "Advanced %s Turtle");
        this.add(((TurtleBlock)ModRegistry.Blocks.TURTLE_ADVANCED.get()).m_7705_() + ".upgraded_twice", "Advanced %s %s Turtle");
        this.add((Item)ModRegistry.Items.DISK.get(), "Floppy Disk");
        this.add((Item)ModRegistry.Items.TREASURE_DISK.get(), "Floppy Disk");
        this.add((Item)ModRegistry.Items.PRINTED_PAGE.get(), "Printed Page");
        this.add((Item)ModRegistry.Items.PRINTED_PAGES.get(), "Printed Pages");
        this.add((Item)ModRegistry.Items.PRINTED_BOOK.get(), "Printed Book");
        this.add((Item)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), "Pocket Computer");
        this.add(((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()).m_5524_() + ".upgraded", "%s Pocket Computer");
        this.add((Item)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get(), "Advanced Pocket Computer");
        this.add(((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get()).m_5524_() + ".upgraded", "Advanced %s Pocket Computer");
        this.add(ComputerCraftTags.Items.COMPUTER, "Computers");
        this.add(ComputerCraftTags.Items.TURTLE, "Turtles");
        this.add(ComputerCraftTags.Items.WIRED_MODEM, "Wired modems");
        this.add(ComputerCraftTags.Items.MONITOR, "Monitors");
        this.add("upgrade.minecraft.diamond_sword.adjective", "Melee");
        this.add("upgrade.minecraft.diamond_shovel.adjective", "Digging");
        this.add("upgrade.minecraft.diamond_pickaxe.adjective", "Mining");
        this.add("upgrade.minecraft.diamond_axe.adjective", "Felling");
        this.add("upgrade.minecraft.diamond_hoe.adjective", "Farming");
        this.add("upgrade.minecraft.crafting_table.adjective", "Crafty");
        this.add("upgrade.computercraft.wireless_modem_normal.adjective", "Wireless");
        this.add("upgrade.computercraft.wireless_modem_advanced.adjective", "Ender");
        this.add("upgrade.computercraft.speaker.adjective", "Noisy");
        this.add("chat.computercraft.wired_modem.peripheral_connected", "Peripheral \"%s\" connected to network");
        this.add("chat.computercraft.wired_modem.peripheral_disconnected", "Peripheral \"%s\" disconnected from network");
        this.add("commands.computercraft.synopsis", "Various commands for controlling computers.");
        this.add("commands.computercraft.desc", "The /computercraft command provides various debugging and administrator tools for controlling and interacting with computers.");
        this.add("commands.computercraft.help.synopsis", "Provide help for a specific command");
        this.add("commands.computercraft.help.desc", "Displays this help message");
        this.add("commands.computercraft.help.no_children", "%s has no sub-commands");
        this.add("commands.computercraft.help.no_command", "No such command '%s'");
        this.add("commands.computercraft.dump.synopsis", "Display the status of computers.");
        this.add("commands.computercraft.dump.desc", "Display the status of all computers or specific information about one computer. You can specify the computer's instance id (e.g. 123), computer id (e.g #123) or label (e.g. \"@My Computer\").");
        this.add("commands.computercraft.dump.action", "View more info about this computer");
        this.add("commands.computercraft.dump.open_path", "View this computer's files");
        this.add("commands.computercraft.shutdown.synopsis", "Shutdown computers remotely.");
        this.add("commands.computercraft.shutdown.desc", "Shutdown the listed computers or all if none are specified. You can specify the computer's instance id (e.g. 123), computer id (e.g #123) or label (e.g. \"@My Computer\").");
        this.add("commands.computercraft.shutdown.done", "Shutdown %s/%s computers");
        this.add("commands.computercraft.turn_on.synopsis", "Turn computers on remotely.");
        this.add("commands.computercraft.turn_on.desc", "Turn on the listed computers. You can specify the computer's instance id (e.g. 123), computer id (e.g #123) or label (e.g. \"@My Computer\").");
        this.add("commands.computercraft.turn_on.done", "Turned on %s/%s computers");
        this.add("commands.computercraft.tp.synopsis", "Teleport to a specific computer.");
        this.add("commands.computercraft.tp.desc", "Teleport to the location of a computer. You can either specify the computer's instance id (e.g. 123) or computer id (e.g #123).");
        this.add("commands.computercraft.tp.action", "Teleport to this computer");
        this.add("commands.computercraft.view.synopsis", "View the terminal of a computer.");
        this.add("commands.computercraft.view.desc", "Open the terminal of a computer, allowing remote control of a computer. This does not provide access to turtle's inventories. You can either specify the computer's instance id (e.g. 123) or computer id (e.g #123).");
        this.add("commands.computercraft.view.action", "View this computer");
        this.add("commands.computercraft.view.not_player", "Cannot open terminal for non-player");
        this.add("commands.computercraft.track.synopsis", "Track execution times for computers.");
        this.add("commands.computercraft.track.desc", "Track how long computers execute for, as well as how many events they handle. This presents information in a similar way to /forge track and can be useful for diagnosing lag.");
        this.add("commands.computercraft.track.start.synopsis", "Start tracking all computers");
        this.add("commands.computercraft.track.start.desc", "Start tracking all computers' execution times and event counts. This will discard the results of previous runs.");
        this.add("commands.computercraft.track.start.stop", "Run %s to stop tracking and view the results");
        this.add("commands.computercraft.track.stop.synopsis", "Stop tracking all computers");
        this.add("commands.computercraft.track.stop.desc", "Stop tracking all computers' events and execution times");
        this.add("commands.computercraft.track.stop.action", "Click to stop tracking");
        this.add("commands.computercraft.track.stop.not_enabled", "Not currently tracking computers");
        this.add("commands.computercraft.track.dump.synopsis", "Dump the latest track results");
        this.add("commands.computercraft.track.dump.desc", "Dump the latest results of computer tracking.");
        this.add("commands.computercraft.track.dump.no_timings", "No timings available");
        this.add("commands.computercraft.track.dump.computer", "Computer");
        this.add("commands.computercraft.queue.synopsis", "Send a computer_command event to a command computer");
        this.add("commands.computercraft.queue.desc", "Send a computer_command event to a command computer, passing through the additional arguments. This is mostly designed for map makers, acting as a more computer-friendly version of /trigger. Any player can run the command, which would most likely be done through a text component's click event.");
        this.add("commands.computercraft.generic.no_position", "<no pos>");
        this.add("commands.computercraft.generic.position", "%s, %s, %s");
        this.add("commands.computercraft.generic.yes", "Y");
        this.add("commands.computercraft.generic.no", "N");
        this.add("commands.computercraft.generic.exception", "Unhandled exception (%s)");
        this.add("commands.computercraft.generic.additional_rows", "%d additional rows\u2026");
        this.add("argument.computercraft.computer.instance", "Unique instance ID");
        this.add("argument.computercraft.computer.id", "Computer ID");
        this.add("argument.computercraft.computer.label", "Computer label");
        this.add("argument.computercraft.computer.distance", "Distance to entity");
        this.add("argument.computercraft.computer.family", "Computer family");
        this.add("argument.computercraft.computer.no_matching", "No computers matching '%s'");
        this.add("argument.computercraft.computer.many_matching", "Multiple computers matching '%s' (instances %s)");
        this.add("argument.computercraft.tracking_field.no_field", "Unknown field '%s'");
        this.add("argument.computercraft.argument_expected", "Argument expected");
        this.add("argument.computercraft.unknown_computer_family", "Unknown computer family '%s'");
        this.add(Metrics.COMPUTER_TASKS, "Tasks");
        this.add(Metrics.SERVER_TASKS, "Server tasks");
        this.add(Metrics.JAVA_ALLOCATION, "Java Allocations");
        this.add(Metrics.PERIPHERAL_OPS, "Peripheral calls");
        this.add(Metrics.FS_OPS, "Filesystem operations");
        this.add(Metrics.HTTP_REQUESTS, "HTTP requests");
        this.add(Metrics.HTTP_UPLOAD, "HTTP upload");
        this.add(Metrics.HTTP_DOWNLOAD, "HTTP download");
        this.add(Metrics.WEBSOCKET_INCOMING, "Websocket incoming");
        this.add(Metrics.WEBSOCKET_OUTGOING, "Websocket outgoing");
        this.add(Metrics.TURTLE_OPS, "Turtle operations");
        this.add("tracking_field.computercraft." + Aggregate.MAX.id(), "%s (max)");
        this.add("tracking_field.computercraft." + Aggregate.AVG.id(), "%s (avg)");
        this.add("tracking_field.computercraft." + Aggregate.COUNT.id(), "%s (count)");
        this.add("gui.computercraft.terminal", "Computer terminal");
        this.add("gui.computercraft.tooltip.copy", "Copy to clipboard");
        this.add("gui.computercraft.tooltip.computer_id", "Computer ID: %s");
        this.add("gui.computercraft.tooltip.disk_id", "Disk ID: %s");
        this.add("gui.computercraft.tooltip.turn_on", "Turn this computer on");
        this.add("gui.computercraft.tooltip.turn_off", "Turn this computer off");
        this.add("gui.computercraft.tooltip.turn_off.key", "Hold Ctrl+S");
        this.add("gui.computercraft.tooltip.terminate", "Stop the currently running code");
        this.add("gui.computercraft.tooltip.terminate.key", "Hold Ctrl+T");
        this.add("gui.computercraft.upload.failed", "Upload Failed");
        this.add("gui.computercraft.upload.failed.computer_off", "You must turn the computer on before uploading files.");
        this.add("gui.computercraft.upload.failed.too_much", "Your files are too large to be uploaded.");
        this.add("gui.computercraft.upload.failed.name_too_long", "File names are too long to be uploaded.");
        this.add("gui.computercraft.upload.failed.too_many_files", "Cannot upload this many files.");
        this.add("gui.computercraft.upload.failed.generic", "Uploading files failed (%s)");
        this.add("gui.computercraft.upload.failed.corrupted", "Files corrupted when uploading. Please try again.");
        this.add("gui.computercraft.upload.no_response", "Transferring Files");
        this.add("gui.computercraft.upload.no_response.msg", "Your computer has not used your transferred files. You may need to run the %s program and try again.");
        this.add("gui.computercraft.pocket_computer_overlay", "Pocket computer open. Press ESC to close.");
        this.addConfigEntry(ConfigSpec.computerSpaceLimit, "Computer space limit (bytes)");
        this.addConfigEntry(ConfigSpec.floppySpaceLimit, "Floppy Disk space limit (bytes)");
        this.addConfigEntry(ConfigSpec.uploadMaxSize, "File upload size limit (bytes)");
        this.addConfigEntry(ConfigSpec.maximumFilesOpen, "Maximum files open per computer");
        this.addConfigEntry(ConfigSpec.defaultComputerSettings, "Default Computer settings");
        this.addConfigEntry(ConfigSpec.logComputerErrors, "Log computer errors");
        this.addConfigEntry(ConfigSpec.commandRequireCreative, "Command computers require creative");
        this.addConfigEntry(ConfigSpec.disabledGenericMethods, "Disabled generic methods");
        this.addConfigGroup(ConfigSpec.serverSpec, "execution", "Execution");
        this.addConfigEntry(ConfigSpec.computerThreads, "Computer threads");
        this.addConfigEntry(ConfigSpec.maxMainGlobalTime, "Server tick global time limit");
        this.addConfigEntry(ConfigSpec.maxMainComputerTime, "Server tick computer time limit");
        this.addConfigGroup(ConfigSpec.serverSpec, "http", "HTTP");
        this.addConfigEntry(ConfigSpec.httpEnabled, "Enable the HTTP API");
        this.addConfigEntry(ConfigSpec.httpWebsocketEnabled, "Enable websockets");
        this.addConfigEntry(ConfigSpec.httpRules, "Allow/deny rules");
        this.addConfigEntry(ConfigSpec.httpMaxRequests, "Maximum concurrent requests");
        this.addConfigEntry(ConfigSpec.httpMaxWebsockets, "Maximum concurrent websockets");
        this.addConfigGroup(ConfigSpec.serverSpec, "http.bandwidth", "Bandwidth");
        this.addConfigEntry(ConfigSpec.httpDownloadBandwidth, "Global download limit");
        this.addConfigEntry(ConfigSpec.httpUploadBandwidth, "Global upload limit");
        this.addConfigGroup(ConfigSpec.serverSpec, "http.proxy", "Proxy");
        this.addConfigEntry(ConfigSpec.httpProxyHost, "Host name");
        this.addConfigEntry(ConfigSpec.httpProxyPort, "Port");
        this.addConfigEntry(ConfigSpec.httpProxyType, "Proxy type");
        this.addConfigGroup(ConfigSpec.serverSpec, "peripheral", "Peripherals");
        this.addConfigEntry(ConfigSpec.commandBlockEnabled, "Enable command block peripheral");
        this.addConfigEntry(ConfigSpec.modemRange, "Modem range (default)");
        this.addConfigEntry(ConfigSpec.modemHighAltitudeRange, "Modem range (high-altitude)");
        this.addConfigEntry(ConfigSpec.modemRangeDuringStorm, "Modem range (bad weather)");
        this.addConfigEntry(ConfigSpec.modemHighAltitudeRangeDuringStorm, "Modem range (high-altitude, bad weather)");
        this.addConfigEntry(ConfigSpec.maxNotesPerTick, "Maximum notes that a computer can play at once");
        this.addConfigEntry(ConfigSpec.monitorBandwidth, "Monitor bandwidth");
        this.addConfigGroup(ConfigSpec.serverSpec, "turtle", "Turtles");
        this.addConfigEntry(ConfigSpec.turtlesNeedFuel, "Enable fuel");
        this.addConfigEntry(ConfigSpec.turtleFuelLimit, "Turtle fuel limit");
        this.addConfigEntry(ConfigSpec.advancedTurtleFuelLimit, "Advanced Turtle fuel limit");
        this.addConfigEntry(ConfigSpec.turtlesCanPush, "Turtles can push entities");
        this.addConfigGroup(ConfigSpec.serverSpec, "term_sizes", "Terminal sizes");
        this.addConfigGroup(ConfigSpec.serverSpec, "term_sizes.computer", "Computer");
        this.addConfigEntry(ConfigSpec.computerTermWidth, "Terminal width");
        this.addConfigEntry(ConfigSpec.computerTermHeight, "Terminal height");
        this.addConfigGroup(ConfigSpec.serverSpec, "term_sizes.pocket_computer", "Pocket Computer");
        this.addConfigEntry(ConfigSpec.pocketTermWidth, "Terminal width");
        this.addConfigEntry(ConfigSpec.pocketTermHeight, "Terminal height");
        this.addConfigGroup(ConfigSpec.serverSpec, "term_sizes.monitor", "Monitor");
        this.addConfigEntry(ConfigSpec.monitorWidth, "Max monitor width");
        this.addConfigEntry(ConfigSpec.monitorHeight, "Max monitor height");
        this.addConfigEntry(ConfigSpec.monitorRenderer, "Monitor renderer");
        this.addConfigEntry(ConfigSpec.monitorDistance, "Monitor distance");
        this.addConfigEntry(ConfigSpec.uploadNagDelay, "Upload nag delay");
    }

    private Stream<String> getExpectedKeys() {
        return Stream.of(RegistryWrappers.BLOCKS.stream().filter(x -> RegistryWrappers.BLOCKS.getKey((Block)x).m_135827_().equals("computercraft")).map(Block::m_7705_).filter(x -> !x.startsWith("block.minecraft.")), RegistryWrappers.ITEMS.stream().filter(x -> RegistryWrappers.ITEMS.getKey((Item)x).m_135827_().equals("computercraft")).map(Item::m_5524_), this.turtleUpgrades.getGeneratedUpgrades().stream().map(UpgradeBase::getUnlocalisedAdjective), this.pocketUpgrades.getGeneratedUpgrades().stream().map(UpgradeBase::getUnlocalisedAdjective), Metric.metrics().values().stream().map(x -> "tracking_field.computercraft." + x.name() + ".name"), ConfigSpec.serverSpec.entries().map(ConfigFile.Entry::translationKey), ConfigSpec.clientSpec.entries().map(ConfigFile.Entry::translationKey), ComputerSelector.options().values().stream().map(ComputerSelector.Option::translationKey)).flatMap(x -> x);
    }

    private void add(String id, String text) {
        Objects.requireNonNull(id, "id cannot be null");
        Objects.requireNonNull(text, "text cannot be null");
        if (this.translations.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate translation " + id);
        }
        this.translations.put(id, text);
    }

    private void add(Item item, String text) {
        this.add(item.m_5524_(), text);
    }

    private void add(Metric metric, String text) {
        this.add("tracking_field.computercraft." + metric.name() + ".name", text);
    }

    private void add(TagKey<Item> tag, String text) {
        this.add("tag.item." + tag.f_203868_().m_135827_() + "." + tag.f_203868_().m_135815_(), text);
    }

    private void addConfigGroup(ConfigFile spec, String path, String text) {
        ConfigFile.Entry entry = spec.getEntry(path);
        if (!(entry instanceof ConfigFile.Group)) {
            throw new IllegalArgumentException("Cannot find group " + path);
        }
        this.addConfigEntry(entry, text);
    }

    private void addConfigEntry(ConfigFile.Entry value, String text) {
        this.add(value.translationKey(), text);
        this.add(value.translationKey() + ".tooltip", value.comment());
    }
}

