/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.poi;

import com.abdelaziz.canary.common.util.Pos;
import com.abdelaziz.canary.common.util.collections.ListeningLong2ObjectOpenHashMap;
import com.abdelaziz.canary.common.world.interests.RegionBasedStorageSectionExtended;
import com.google.common.collect.AbstractIterator;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionStorage.class})
public abstract class SectionStorageMixin<R>
implements RegionBasedStorageSectionExtended<R> {
    private Long2ObjectOpenHashMap<BitSet> columns;
    @Shadow
    @Final
    protected LevelHeightAccessor f_156618_;
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> f_63774_;

    @Shadow
    protected abstract void m_63814_(ChunkPos var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Path p_223509_, Function p_223510_, Function p_223511_, DataFixer p_223512_, DataFixTypes p_223513_, boolean p_223514_, RegistryAccess p_223515_, LevelHeightAccessor p_223516_, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.f_63774_ = new ListeningLong2ObjectOpenHashMap<Optional>(this::onEntryAdded, this::onEntryRemoved);
    }

    private void onEntryRemoved(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.f_156618_, SectionPos.m_123225_((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.f_156618_)) {
            return;
        }
        int x = SectionPos.m_123213_((long)key);
        long pos = ChunkPos.m_45589_((int)x, (int)(z = SectionPos.m_123230_((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags != null) {
            flags.clear(y);
            if (flags.isEmpty()) {
                this.columns.remove(pos);
            }
        }
    }

    private void onEntryAdded(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.f_156618_, SectionPos.m_123225_((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.f_156618_)) {
            return;
        }
        int x = SectionPos.m_123213_((long)key);
        long pos = ChunkPos.m_45589_((int)x, (int)(z = SectionPos.m_123230_((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags == null) {
            flags = new BitSet(Pos.SectionYIndex.getNumYSections(this.f_156618_));
            this.columns.put(pos, (Object)flags);
        }
        flags.set(y, value.isPresent());
    }

    @Override
    public Stream<R> getWithinChunkColumn(int chunkX, int chunkZ) {
        BitSet sectionsWithPOI = this.getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return Stream.empty();
        }
        ArrayList list = new ArrayList();
        int minYSection = Pos.SectionYCoord.getMinYSection(this.f_156618_);
        int chunkYIndex = sectionsWithPOI.nextSetBit(0);
        while (chunkYIndex != -1) {
            int chunkY = chunkYIndex + minYSection;
            Object r = ((Optional)this.f_63774_.get(SectionPos.m_123209_((int)chunkX, (int)chunkY, (int)chunkZ))).orElse(null);
            if (r != null) {
                list.add(r);
            }
            chunkYIndex = sectionsWithPOI.nextSetBit(chunkYIndex + 1);
        }
        return list.stream();
    }

    @Override
    public Iterable<R> getInChunkColumn(final int chunkX, final int chunkZ) {
        final BitSet sectionsWithPOI = this.getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return Collections::emptyIterator;
        }
        final Long2ObjectMap<Optional<R>> storage = this.f_63774_;
        final LevelHeightAccessor world = this.f_156618_;
        return () -> new AbstractIterator<R>(){
            private int nextBit;
            {
                this.nextBit = sectionsWithPOI.nextSetBit(0);
            }

            protected R computeNext() {
                while (this.nextBit >= 0) {
                    Optional next = (Optional)storage.get(SectionPos.m_123209_((int)chunkX, (int)Pos.SectionYCoord.fromSectionIndex(world, this.nextBit), (int)chunkZ));
                    this.nextBit = sectionsWithPOI.nextSetBit(this.nextBit + 1);
                    if (!next.isPresent()) continue;
                    return next.get();
                }
                return this.endOfData();
            }
        };
    }

    private BitSet getNonEmptyPOISections(int chunkX, int chunkZ) {
        long pos = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        BitSet flags = this.getNonEmptySections(pos, false);
        if (flags != null) {
            return flags;
        }
        this.m_63814_(new ChunkPos(pos));
        return this.getNonEmptySections(pos, true);
    }

    private BitSet getNonEmptySections(long pos, boolean required) {
        BitSet set = (BitSet)this.columns.get(pos);
        if (set == null && required) {
            throw new NullPointerException("No data is present for column: " + new ChunkPos(pos));
        }
        return set;
    }
}

