/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.will;

import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.util.helper.InventoryHelper;

public class PlayerDemonWillHandler {
    public static double getTotalDemonWill(EnumDemonWillType type, Player player) {
        NonNullList<ItemStack> inventory = InventoryHelper.getAllInventories(player);
        double souls = 0.0;
        for (ItemStack stack : inventory) {
            if (stack.m_41720_() instanceof IDemonWill && ((IDemonWill)stack.m_41720_()).getType(stack) == type) {
                souls += ((IDemonWill)stack.m_41720_()).getWill(type, stack);
                continue;
            }
            if (!(stack.m_41720_() instanceof IDemonWillGem)) continue;
            souls += ((IDemonWillGem)stack.m_41720_()).getWill(type, stack);
        }
        return souls;
    }

    public static EnumDemonWillType getLargestWillType(Player player) {
        EnumDemonWillType type = EnumDemonWillType.DEFAULT;
        double max = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        for (EnumDemonWillType testType : EnumDemonWillType.values()) {
            double value = PlayerDemonWillHandler.getTotalDemonWill(testType, player);
            if (!(value > max)) continue;
            type = testType;
        }
        return type;
    }

    public static boolean isDemonWillFull(EnumDemonWillType type, Player player) {
        NonNullList<ItemStack> inventory = InventoryHelper.getAllInventories(player);
        boolean hasGem = false;
        for (ItemStack stack : inventory) {
            if (!(stack.m_41720_() instanceof IDemonWillGem)) continue;
            hasGem = true;
            if (!(((IDemonWillGem)stack.m_41720_()).getWill(type, stack) < (double)((IDemonWillGem)stack.m_41720_()).getMaxWill(type, stack))) continue;
            return false;
        }
        return hasGem;
    }

    public static double consumeDemonWill(EnumDemonWillType type, Player player, double amount) {
        double consumed = 0.0;
        NonNullList<ItemStack> inventory = InventoryHelper.getAllInventories(player);
        for (int i = 0; i < inventory.size(); ++i) {
            if (consumed >= amount) {
                return consumed;
            }
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.m_41720_() instanceof IDemonWill && ((IDemonWill)stack.m_41720_()).getType(stack) == type) {
                consumed += ((IDemonWill)stack.m_41720_()).drainWill(type, stack, amount - consumed);
                if (!(((IDemonWill)stack.m_41720_()).getWill(type, stack) <= 0.0)) continue;
                inventory.set(i, (Object)ItemStack.f_41583_);
                continue;
            }
            if (!(stack.m_41720_() instanceof IDemonWillGem)) continue;
            consumed += ((IDemonWillGem)stack.m_41720_()).drainWill(type, stack, amount - consumed, true);
        }
        return consumed;
    }

    public static ItemStack addDemonWill(Player player, ItemStack willStack) {
        if (willStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        NonNullList<ItemStack> inventory = InventoryHelper.getAllInventories(player);
        for (ItemStack stack : inventory) {
            ItemStack newStack;
            if (!(stack.m_41720_() instanceof IDemonWillGem) || !(newStack = ((IDemonWillGem)stack.m_41720_()).fillDemonWillGem(stack, willStack)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return willStack;
    }

    public static double addDemonWill(EnumDemonWillType type, Player player, double amount) {
        ItemStack stack;
        NonNullList<ItemStack> inventory = InventoryHelper.getAllInventories(player);
        double remaining = amount;
        Iterator iterator = inventory.iterator();
        while (!(!iterator.hasNext() || (stack = (ItemStack)iterator.next()).m_41720_() instanceof IDemonWillGem && (remaining -= ((IDemonWillGem)stack.m_41720_()).fillWill(type, stack, remaining, true)) <= 0.0)) {
        }
        return amount - remaining;
    }

    public static double addDemonWill(EnumDemonWillType type, Player player, double amount, ItemStack ignored) {
        ItemStack stack;
        NonNullList<ItemStack> inventory = InventoryHelper.getAllInventories(player);
        double remaining = amount;
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()).equals(ignored) || !(stack.m_41720_() instanceof IDemonWillGem) || !((remaining -= ((IDemonWillGem)stack.m_41720_()).fillWill(type, stack, remaining, true)) <= 0.0))) {
        }
        return amount - remaining;
    }
}

