/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="placer")
public class RitualPlacer
extends Ritual {
    public static final String PLACER_RANGE = "placerRange";
    public static final String CHEST_RANGE = "chest";

    public RitualPlacer() {
        super("ritualPlacer", 0, 5000, "ritual.bloodmagic.placerRitual");
        this.addBlockRange(PLACER_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 0, -2), 5, 1, 5));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(PLACER_RANGE, 300, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        BlockEntity tileEntity = world.m_7702_(chestRange.getContainedPositions(masterPos).get(0));
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor areaDescriptor = masterRitualStone.getBlockRange(PLACER_RANGE);
        if (tileEntity != null) {
            IItemHandler itemHandler = Utils.getInventory(tileEntity, null);
            if (itemHandler.getSlots() <= 0) {
                return;
            }
            block0: for (BlockPos blockPos : areaDescriptor.getContainedPositions(masterRitualStone.getMasterBlockPos())) {
                BlockPlaceContext ctx = new BlockPlaceContext(world, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)new Vec3(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)blockPos));
                if (!world.m_8055_(blockPos).m_60629_(ctx)) continue;
                for (int invSlot = 0; invSlot < itemHandler.getSlots(); ++invSlot) {
                    InteractionResult result;
                    ItemStack stack = itemHandler.extractItem(invSlot, 1, true);
                    if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem) || !(result = ((BlockItem)stack.m_41720_()).m_40576_(ctx)).m_19077_()) continue;
                    itemHandler.extractItem(invSlot, 1, false);
                    tileEntity.m_6596_();
                    masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                    break block0;
                }
            }
        }
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public int getRefreshTime() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, 3, 0, -2, EnumRuneType.WATER);
        this.addRune(components, 2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, 2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, -3, 0, -2, EnumRuneType.WATER);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualPlacer();
    }
}

