/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionFill
extends RecipePotionFlaskBase {
    public int maxEffects;

    public RecipePotionFill(ResourceLocation id, List<Ingredient> input, int maxEffects, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.maxEffects = maxEffects;
    }

    public RecipeSerializer<? extends RecipePotionFill> m_7707_() {
        return BloodMagicRecipeSerializers.POTIONFILL.getRecipeSerializer();
    }

    @Override
    public RecipeType<RecipePotionFlaskBase> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.POTIONFLASK.get();
    }

    @Override
    public boolean canModifyFlask(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        return flaskEffectList.size() > 0;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.maxEffects);
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        ItemStack copyStack = flaskStack.m_41777_();
        ArrayList<EffectHolder> flaskEffectCopyList = new ArrayList<EffectHolder>();
        for (int i = 0; i < Math.min(flaskEffectList.size(), this.maxEffects); ++i) {
            flaskEffectCopyList.add(flaskEffectList.get(i));
        }
        ((ItemAlchemyFlask)copyStack.m_41720_()).setEffectHoldersOfFlask(copyStack, flaskEffectCopyList);
        copyStack.m_41721_(0);
        return copyStack;
    }

    @Override
    public ItemStack getExamplePotionFlask() {
        ItemStack flaskStack = new ItemStack((ItemLike)BloodMagicItems.ALCHEMY_FLASK.get());
        flaskStack.m_41721_(8);
        ((ItemAlchemyFlask)flaskStack.m_41720_()).setEffectHoldersOfFlask(flaskStack, this.getExampleEffectList());
        ((ItemAlchemyFlask)flaskStack.m_41720_()).resyncEffectInstances(flaskStack);
        return flaskStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        return 1;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        holderList.add(new EffectHolder(MobEffects.f_19596_, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(MobEffects.f_19607_, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(MobEffects.f_19598_, 3600, 0, 1.0, 1.0));
        return holderList;
    }
}

