/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.core.registry.OrbRegistry;

public class IngredientBloodOrb
extends Ingredient {
    public static final ResourceLocation NAME = new ResourceLocation("bloodmagic", "bloodorb");
    public final int orbTier;

    public static IngredientBloodOrb fromTier(int orbTier) {
        return new IngredientBloodOrb(orbTier);
    }

    public static IngredientBloodOrb fromOrb(BloodOrb orb) {
        return new IngredientBloodOrb(orb.getTier());
    }

    protected IngredientBloodOrb(int orbTier) {
        super(Stream.of(new ItemList(orbTier)));
        this.orbTier = orbTier;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    private static class ItemList
    implements Ingredient.Value {
        private final int orbTier;

        public ItemList(int orbTier) {
            this.orbTier = orbTier;
        }

        public Collection<ItemStack> m_6223_() {
            List<ItemStack> orbGet = OrbRegistry.getOrbsDownToTier(this.orbTier);
            return orbGet;
        }

        public JsonObject m_6544_() {
            JsonObject object = new JsonObject();
            object.addProperty("type", NAME.toString());
            object.addProperty("orb_tier", (Number)this.orbTier);
            return object;
        }
    }

    public static class Serializer
    extends VanillaIngredientSerializer {
        public static final IIngredientSerializer<? extends Ingredient> INSTANCE = new Serializer();

        public Ingredient parse(JsonObject json) {
            return new IngredientBloodOrb(GsonHelper.m_13927_((JsonObject)json, (String)"orb_tier"));
        }
    }
}

