/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class PotionFlaskTransformRecipeBuilder
extends BloodMagicRecipeBuilder<PotionFlaskTransformRecipeBuilder> {
    private final List<Ingredient> input;
    private final ItemStack output;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionFlaskTransformRecipeBuilder(List<Ingredient> input, ItemStack output, int syphon, int ticks, int minimumTier) {
        super(PotionFlaskTransformRecipeBuilder.bmSerializer("flask_potionflasktransform"));
        this.input = input;
        this.output = output;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionFlaskTransformRecipeBuilder flask(ItemStack output, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionFlaskTransformRecipeBuilder(inputList, output, syphon, ticks, minimumTier);
    }

    public PotionFlaskTransformRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    @Override
    protected PotionFillRecipeResult getResult(ResourceLocation id) {
        return new PotionFillRecipeResult(id);
    }

    public class PotionFillRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionFillRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            if (PotionFlaskTransformRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : PotionFlaskTransformRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.m_43942_();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.add("output", SerializerHelper.serializeItemStack(PotionFlaskTransformRecipeBuilder.this.output));
            json.addProperty("syphon", (Number)PotionFlaskTransformRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionFlaskTransformRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionFlaskTransformRecipeBuilder.this.minimumTier);
        }
    }
}

