/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.registries;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.data.DatapackLoader;
import net.roguelogix.phosphophyllite.networking.SimplePhosChannel;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;

public class TurbineCoilRegistry {
    private static final HashMap<Block, CoilData> registry = new HashMap();
    private static final DatapackLoader<TurbineCoilJsonData> dataLoader = new DatapackLoader(TurbineCoilJsonData::new);

    public static synchronized boolean isBlockAllowed(Block block) {
        return registry.containsKey(block);
    }

    public static synchronized CoilData getCoilData(Block block) {
        return registry.get(block);
    }

    public static void loadRegistry() {
        BiggerReactors.LOGGER.info("Loading turbine coils");
        registry.clear();
        List data = dataLoader.loadAll(new ResourceLocation("biggerreactors:ebest/coils"));
        BiggerReactors.LOGGER.info("Loaded " + data.size() + " coil data entries");
        for (TurbineCoilJsonData coilData : data) {
            CoilData properties = new CoilData(coilData.efficiency, coilData.bonus, coilData.extractionRate);
            if (coilData.type == RegistryType.tag) {
                Optional blockTagOptional = BuiltInRegistries.f_256975_.m_203431_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256975_.m_123023_(), (ResourceLocation)coilData.location));
                blockTagOptional.ifPresent(holders -> holders.forEach(blockHolder -> {
                    Block element = (Block)blockHolder.m_203334_();
                    registry.put(element, properties);
                    BiggerReactors.LOGGER.debug("Loaded coil " + ForgeRegistries.BLOCKS.getKey((Object)element));
                }));
                continue;
            }
            if (!ForgeRegistries.BLOCKS.containsKey(coilData.location)) continue;
            registry.put((Block)ForgeRegistries.BLOCKS.getValue(coilData.location), properties);
            BiggerReactors.LOGGER.debug("Loaded coil " + coilData.location);
        }
        BiggerReactors.LOGGER.info("Loaded " + registry.size() + " coil entries");
    }

    public static class CoilData {
        public final double efficiency;
        public final double bonus;
        public final double extractionRate;

        public CoilData(double efficiency, double bonus, double extractionRate) {
            this.efficiency = efficiency;
            this.bonus = bonus;
            this.extractionRate = extractionRate;
        }
    }

    private static class TurbineCoilJsonData {
        @ConfigValue
        RegistryType type = RegistryType.tag;
        @ConfigValue
        ResourceLocation location = new ResourceLocation("dirt");
        @ConfigValue(range="(0,)")
        double efficiency;
        @ConfigValue(range="(0,)")
        double extractionRate;
        @ConfigValue(range="(0,2)")
        double bonus;

        private TurbineCoilJsonData() {
        }
    }

    private static enum RegistryType {
        tag,
        registry;

    }

    public static class Client {
        private static final SimplePhosChannel CHANNEL = new SimplePhosChannel(new ResourceLocation("biggerreactors", "coil_sync_channel"), "0", Client::readSync);
        private static final ObjectOpenHashSet<Block> coilBlocks = new ObjectOpenHashSet();
        private static final Object2ObjectOpenHashMap<Block, CoilData> coilProperties = new Object2ObjectOpenHashMap();

        @OnModLoad
        private static void onModLoad() {
            MinecraftForge.EVENT_BUS.addListener(Client::datapackEvent);
            if (FMLEnvironment.dist.isClient()) {
                MinecraftForge.EVENT_BUS.addListener(Client::toolTipEvent);
            }
        }

        public static void datapackEvent(OnDatapackSyncEvent e) {
            ServerPlayer player = e.getPlayer();
            if (player == null) {
                return;
            }
            if (BiggerReactors.LOG_DEBUG) {
                BiggerReactors.LOGGER.debug("Sending coil list to player: " + player);
            }
            CHANNEL.sendToPlayer(player, Client.writeSync());
        }

        private static PhosphophylliteCompound writeSync() {
            ObjectArrayList list = new ObjectArrayList();
            ObjectArrayList propertiesList = new ObjectArrayList();
            for (Map.Entry<Block, CoilData> value : registry.entrySet()) {
                ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)value.getKey());
                if (location == null) continue;
                list.add((Object)location.toString());
                DoubleArrayList properties = new DoubleArrayList();
                properties.add(value.getValue().efficiency);
                properties.add(value.getValue().extractionRate);
                properties.add(value.getValue().bonus);
                propertiesList.add((Object)properties);
            }
            PhosphophylliteCompound compound = new PhosphophylliteCompound();
            compound.put("list", (List)list);
            compound.put("propertiesList", (List)propertiesList);
            return compound;
        }

        private static void readSync(PhosphophylliteCompound compound) {
            coilBlocks.clear();
            List list = compound.getList("list");
            List propertiesList = compound.getList("propertiesList");
            if (BiggerReactors.LOG_DEBUG) {
                BiggerReactors.LOGGER.debug("Received coil list from server with length of " + list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                String value = (String)list.get(i);
                DoubleArrayList properties = (DoubleArrayList)propertiesList.get(i);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(value));
                if (block == null) {
                    return;
                }
                if (BiggerReactors.LOG_DEBUG) {
                    BiggerReactors.LOGGER.debug("Block " + value + " added as coil on client");
                }
                coilBlocks.add((Object)block);
                coilProperties.put((Object)block, (Object)new CoilData(properties.getDouble(0), properties.getDouble(1), properties.getDouble(2)));
            }
        }

        public static void toolTipEvent(ItemTooltipEvent event) {
            Item item = event.getItemStack().m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (!coilBlocks.contains((Object)blockItem.m_40614_())) {
                    return;
                }
            } else {
                return;
            }
            if (Minecraft.m_91087_().f_91066_.f_92125_ || Config.CONFIG.AlwaysShowTooltips) {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.biggerreactors.is_a_coil"));
            }
        }

        public static Map<Block, CoilData> getImmutableRegistry() {
            return Collections.unmodifiableMap(coilProperties);
        }
    }
}

