/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client.deps.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.client.deps.jei.classic.reactor.BlockModeratorCategory;
import net.roguelogix.biggerreactors.client.deps.jei.classic.reactor.FluidModeratorCategory;
import net.roguelogix.biggerreactors.client.deps.jei.classic.turbine.CoilCategory;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorTerminal;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineTerminal;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;

@JeiPlugin
public class BiggerReactorsJEIPlugin
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("biggerreactors", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockModeratorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidModeratorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CoilCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ReactorTerminal.INSTANCE), new RecipeType[]{BlockModeratorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ReactorTerminal.INSTANCE), new RecipeType[]{FluidModeratorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TurbineTerminal.INSTANCE), new RecipeType[]{CoilCategory.RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!Config.CONFIG.EnableJEIIntegration) {
            return;
        }
        List recipes = TurbineCoilRegistry.Client.getImmutableRegistry().entrySet().stream().map(e -> new CoilCategory.Recipe(new ItemStack((ItemLike)((Block)e.getKey()).m_5456_()), (TurbineCoilRegistry.CoilData)e.getValue())).collect(Collectors.toList());
        registration.addRecipes(CoilCategory.RECIPE_TYPE, recipes);
        ArrayList fluidModeratorRecipes = new ArrayList();
        ArrayList blockModeratorRecipes = new ArrayList();
        ReactorModeratorRegistry.Client.forEach((block, moderatorProperties) -> {
            if (block instanceof LiquidBlock) {
                LiquidBlock fluidBlock = (LiquidBlock)block;
                FluidStack stack = new FluidStack((Fluid)fluidBlock.getFluid(), 1000);
                fluidModeratorRecipes.add(new FluidModeratorCategory.Recipe(stack, (ReactorModeratorRegistry.IModeratorProperties)moderatorProperties));
            } else if (!(block instanceof AirBlock)) {
                ItemStack stack = new ItemStack((ItemLike)block.m_5456_());
                blockModeratorRecipes.add(new BlockModeratorCategory.Recipe(stack, (ReactorModeratorRegistry.IModeratorProperties)moderatorProperties));
            }
        });
        registration.addRecipes(FluidModeratorCategory.RECIPE_TYPE, fluidModeratorRecipes);
        registration.addRecipes(BlockModeratorCategory.RECIPE_TYPE, blockModeratorRecipes);
    }
}

