/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.block.entity;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import gripe._90.arseng.definition.ArsEngBlocks;
import gripe._90.arseng.me.key.SourceKey;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MESourceJarBlockEntity
extends SourceJarTile
implements IGridConnectedBlockEntity {
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setVisualRepresentation(ArsEngBlocks.ME_SOURCE_JAR).setInWorldNode(true).setTagName("proxy");
    private final IActionSource actionSource = IActionSource.ofMachine(() -> ((IManagedGridNode)this.getMainNode()).getNode());
    private boolean setChangedQueued;
    private boolean saving;

    public MESourceJarBlockEntity(BlockPos pos, BlockState state) {
        super(ArsEngBlocks.ME_SOURCE_JAR_ENTITY, pos, state);
    }

    public int addSource(int source) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null && this.getMainNode().isActive() ? (int)StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)SourceKey.KEY, (long)source, (IActionSource)this.actionSource) : 0;
    }

    public int removeSource(int source) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null && this.getMainNode().isActive() ? (int)StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)SourceKey.KEY, (long)source, (IActionSource)this.actionSource) : 0;
    }

    public int getSource() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || this.saving) {
            return super.getSource();
        }
        return this.getMainNode().isActive() ? (int)grid.getStorageService().getInventory().extract(SourceKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource) : 0;
    }

    public int getMaxSource() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || this.saving) {
            return super.getMaxSource();
        }
        int oldSource = super.getSource();
        long sourceCap = 0L;
        if (this.getMainNode().isActive()) {
            MEStorage storage = grid.getStorageService().getInventory();
            super.setSource((int)storage.extract(SourceKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource));
            sourceCap = storage.extract(SourceKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource) + storage.insert(SourceKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
        } else {
            super.setSource(0);
        }
        if (oldSource != super.getSource()) {
            this.m_6596_();
        }
        return sourceCap > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)sourceCap;
    }

    public int getTransferRate() {
        return this.getMainNode().isActive() ? super.getTransferRate() : 0;
    }

    public boolean canAcceptSource() {
        return super.canAcceptSource() && this.getMainNode().isActive();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void saveChanges() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            this.m_6596_();
        } else {
            this.f_58857_.m_151543_(this.f_58858_);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private void setChangedAtEndOfTick() {
        this.m_6596_();
        this.setChangedQueued = false;
    }

    public void m_183515_(CompoundTag tag) {
        try {
            this.saving = true;
            super.m_183515_(tag);
        }
        finally {
            this.saving = false;
        }
        this.getMainNode().saveToNBT(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.getMainNode().loadFromNBT(tag);
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void m_7651_() {
        super.m_7651_();
        this.getMainNode().destroy();
    }

    public void m_6339_() {
        super.m_6339_();
        GridHelper.onFirstTick((BlockEntity)this, be -> be.getMainNode().create(be.m_58904_(), be.m_58899_()));
    }

    public int calculateComparatorLevel() {
        IGrid grid = this.getMainNode().getGrid();
        long currentSource = 0L;
        long freeSource = 0L;
        if (grid == null) {
            currentSource = super.getSource();
            freeSource = (long)super.getMaxSource() - currentSource;
        } else if (this.getMainNode().isActive()) {
            MEStorage storage = grid.getStorageService().getInventory();
            currentSource = storage.extract(SourceKey.KEY, Long.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
            freeSource = storage.insert(SourceKey.KEY, Long.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
        }
        return currentSource != 0L ? (int)Math.ceil(1.0 / (1.0 + (double)freeSource / (double)currentSource) * 15.0) : 0;
    }

    public boolean updateBlock() {
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (this.getMainNode().hasGridBooted()) {
            this.getMaxSource();
        }
    }

    public void getTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.source_jar.fullness", (Object[])new Object[]{Math.min(this.getSource() * 100 / this.getMaxSource(), 100)}));
    }

    public void m_155250_(@NotNull BlockState state) {
        BlockOrientation previousOrientation = BlockOrientation.get((BlockState)this.m_58900_());
        super.m_155250_(state);
        BlockOrientation newOrientation = BlockOrientation.get((BlockState)this.m_58900_());
        if (previousOrientation != newOrientation) {
            this.getMainNode().setExposedOnSides(this.getGridConnectableSides(newOrientation));
        }
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return Set.of(Direction.UP, Direction.DOWN, orientation.getSide(RelativeSide.BACK));
    }
}

