/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.client.gui.me.patternaccess.PatternAccessTermScreen;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PatternAccessTerminalPacket
extends BasePacket {
    private boolean fullUpdate;
    private long inventoryId;
    private int inventorySize;
    private long sortBy;
    private PatternContainerGroup group;
    private Int2ObjectMap<ItemStack> slots;

    public PatternAccessTerminalPacket(FriendlyByteBuf stream) {
        this.inventoryId = stream.m_130258_();
        this.fullUpdate = stream.readBoolean();
        if (this.fullUpdate) {
            this.inventorySize = stream.m_130242_();
            this.sortBy = stream.m_130258_();
            this.group = PatternContainerGroup.readFromPacket(stream);
        }
        int slotsCount = stream.m_130242_();
        this.slots = new Int2ObjectArrayMap(slotsCount);
        for (int i = 0; i < slotsCount; ++i) {
            int slot = stream.m_130242_();
            ItemStack item = stream.m_130267_();
            this.slots.put(slot, (Object)item);
        }
    }

    private PatternAccessTerminalPacket(boolean fullUpdate, long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<ItemStack> slots) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer((int)2048));
        data.writeInt(this.getPacketID());
        data.m_130103_(inventoryId);
        data.writeBoolean(fullUpdate);
        if (fullUpdate) {
            data.m_130130_(inventorySize);
            data.m_130103_(sortBy);
            group.writeToPacket(data);
        }
        data.m_130130_(slots.size());
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            data.m_130130_(entry.getIntKey());
            data.m_130055_((ItemStack)entry.getValue());
        }
        this.configureWrite(data);
    }

    public static PatternAccessTerminalPacket fullUpdate(long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<ItemStack> slots) {
        return new PatternAccessTerminalPacket(true, inventoryId, inventorySize, sortBy, group, slots);
    }

    public static PatternAccessTerminalPacket incrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots) {
        return new PatternAccessTerminalPacket(false, inventoryId, 0, 0L, null, slots);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof PatternAccessTermScreen) {
            PatternAccessTermScreen patternAccessTerminal = (PatternAccessTermScreen)screen;
            if (this.fullUpdate) {
                patternAccessTerminal.postFullUpdate(this.inventoryId, this.sortBy, this.group, this.inventorySize, this.slots);
            } else {
                patternAccessTerminal.postIncrementalUpdate(this.inventoryId, this.slots);
            }
        }
    }
}

