/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.menu;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.ITerminalHost;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.FakeSlot;
import gripe._90.appliede.me.misc.TransmutationTerminalHost;
import gripe._90.appliede.me.service.KnowledgeService;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TransmutationTerminalMenu
extends MEStorageMenu {
    public static final MenuType<TransmutationTerminalMenu> TYPE = MenuTypeBuilder.create(TransmutationTerminalMenu::new, TransmutationTerminalHost.class).build("transmutation_terminal");
    protected static final SlotSemantic TRANSMUTE = SlotSemantics.register((String)"APPLIEDE_TRANSMUTE", (boolean)false);
    protected static final SlotSemantic UNLEARN = SlotSemantics.register((String)"APPLIEDE_UNLEARN", (boolean)false);
    private static final String ACTION_SET_SHIFT = "setShiftDestination";
    private static final String ACTION_HIDE_LEARNED = "hideLearnedText";
    private static final String ACTION_HIDE_UNLEARNED = "hideUnlearnedText";
    private final TransmutationTerminalHost host;
    private final Slot transmuteSlot = new FakeSlot(InternalInventory.empty(), 0);
    private final Slot unlearnSlot = new FakeSlot(InternalInventory.empty(), 0);
    @GuiSync(value=1)
    public boolean shiftToTransmute;
    @GuiSync(value=2)
    public int learnedLabelTicks;
    @GuiSync(value=3)
    public int unlearnedLabelTicks;

    public TransmutationTerminalMenu(int id, Inventory ip, TransmutationTerminalHost host) {
        this(TYPE, id, ip, host, true);
    }

    public TransmutationTerminalMenu(MenuType<?> menuType, int id, Inventory ip, TransmutationTerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, (ITerminalHost)host, bindInventory);
        this.host = host;
        this.registerClientAction(ACTION_SET_SHIFT, Boolean.class, host::setShiftToTransmute);
        this.registerClientAction(ACTION_HIDE_LEARNED, () -> --this.learnedLabelTicks);
        this.registerClientAction(ACTION_HIDE_UNLEARNED, () -> --this.unlearnedLabelTicks);
        this.addSlot(this.transmuteSlot, TRANSMUTE);
        this.addSlot(this.unlearnSlot, UNLEARN);
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        IKnowledgeProvider provider;
        KnowledgeService knowledge;
        IGridNode node;
        super.doAction(player, action, slot, id);
        Slot s = this.m_38853_(slot);
        if (s.equals(this.transmuteSlot) && !this.m_142621_().m_41619_()) {
            int transmuted = this.transmuteItem(this.m_142621_(), action == InventoryAction.SPLIT_OR_PLACE_SINGLE, (Player)player);
            ItemStack reduced = this.m_142621_().m_41777_();
            reduced.m_41764_(reduced.m_41613_() - transmuted);
            this.m_142503_(reduced.m_41613_() <= 0 ? ItemStack.f_41583_ : reduced);
        }
        if (s.equals(this.unlearnSlot) && !this.m_142621_().m_41619_() && (node = this.host.getActionableNode()) != null && (knowledge = (KnowledgeService)node.getGrid().getService(KnowledgeService.class)).isTrackingPlayer((Player)player) && (provider = knowledge.getProviderFor(player.m_20148_()).get()).hasKnowledge(this.m_142621_())) {
            provider.removeKnowledge(this.m_142621_());
            provider.syncKnowledgeChange(player, ItemInfo.fromStack((ItemStack)this.m_142621_()), false);
            this.unlearnedLabelTicks = 300;
            this.learnedLabelTicks = 0;
            this.m_38946_();
        }
    }

    private int transmuteItem(ItemStack stack, boolean singleItem, Player player) {
        if (!stack.m_41619_()) {
            IGridNode node = this.host.getActionableNode();
            if (node == null) {
                return 0;
            }
            KnowledgeService knowledge = (KnowledgeService)node.getGrid().getService(KnowledgeService.class);
            if (!knowledge.isTrackingPlayer(player)) {
                return 0;
            }
            return (int)knowledge.getStorage().insertItem(AEItemKey.of((ItemStack)stack), singleItem ? 1L : (long)stack.m_41613_(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player), true, true, this::showLearned);
        }
        return 0;
    }

    public void setShiftToTransmute(boolean transmute) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_SHIFT, transmute);
            return;
        }
        this.shiftToTransmute = transmute;
    }

    public void showLearned() {
        this.learnedLabelTicks = 300;
        this.unlearnedLabelTicks = 0;
        this.m_38946_();
    }

    public void decrementLearnedTicks() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_HIDE_LEARNED);
        }
    }

    public void decrementUnlearnedTicks() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_HIDE_UNLEARNED);
        }
    }

    public ItemStack m_7648_(Player player, int idx) {
        if (this.shiftToTransmute) {
            ItemStack stack = ((Slot)this.f_38839_.get(idx)).m_7993_();
            ItemStack remaining = stack.m_41777_();
            remaining.m_41764_(remaining.m_41613_() - this.transmuteItem(stack, false, player));
            ((Slot)this.f_38839_.get(idx)).m_5852_(remaining.m_41613_() <= 0 ? ItemStack.f_41583_ : remaining);
            return ItemStack.f_41583_;
        }
        return super.m_7648_(player, idx);
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.isServerSide()) {
            this.shiftToTransmute = this.host.getShiftToTransmute();
        }
    }

    public TransmutationTerminalHost getHost() {
        return this.host;
    }
}

