/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.service;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.me.storage.NullInventory;
import gripe._90.appliede.AppliedEConfig;
import gripe._90.appliede.me.misc.TransmutationPattern;
import gripe._90.appliede.me.service.EMCStorage;
import gripe._90.appliede.me.service.TeamProjectEHandler;
import gripe._90.appliede.mixin.misc.TransmutationOfflineAccessor;
import gripe._90.appliede.part.EMCModulePart;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;

public class KnowledgeService
implements IGridService,
IGridServiceProvider {
    private static final int TICKS_PER_SYNC = AppliedEConfig.CONFIG.getSyncThrottleInterval();
    private final List<IManagedGridNode> moduleNodes = new ArrayList<IManagedGridNode>();
    private final Map<UUID, Supplier<IKnowledgeProvider>> providers = new HashMap<UUID, Supplier<IKnowledgeProvider>>();
    private final EMCStorage storage = new EMCStorage(this);
    private final List<IPatternDetails> temporaryPatterns = new ArrayList<IPatternDetails>();
    private final TeamProjectEHandler.Proxy tpeHandler = new TeamProjectEHandler.Proxy();
    private final IGrid grid;
    private Set<AEItemKey> knownItemCache;
    private boolean needsSync;
    private int ticksSinceLastSync;

    public KnowledgeService(IGrid grid) {
        this.grid = grid;
        MinecraftForge.EVENT_BUS.addListener(event -> {
            this.knownItemCache = null;
            this.updatePatterns();
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null) {
                this.knownItemCache = null;
                this.updatePatterns();
            }
        });
    }

    public void addNode(IGridNode gridNode, @Nullable CompoundTag savedData) {
        Object object = gridNode.getOwner();
        if (object instanceof EMCModulePart) {
            EMCModulePart module = (EMCModulePart)((Object)object);
            this.knownItemCache = null;
            this.moduleNodes.add(module.getMainNode());
            UUID uuid = gridNode.getOwningPlayerProfileId();
            if (uuid != null) {
                this.addProvider(uuid);
            }
            this.updatePatterns();
        }
    }

    public void removeNode(IGridNode gridNode) {
        Iterator<IManagedGridNode> iterator = gridNode.getOwner();
        if (iterator instanceof EMCModulePart) {
            EMCModulePart module = (EMCModulePart)((Object)iterator);
            this.knownItemCache = null;
            this.moduleNodes.remove(module.getMainNode());
            this.providers.clear();
            this.tpeHandler.clear();
            for (IManagedGridNode mainNode : this.moduleNodes) {
                UUID uuid;
                IGridNode node = mainNode.getNode();
                if (node == null || (uuid = node.getOwningPlayerProfileId()) == null) continue;
                this.addProvider(uuid);
            }
            this.moduleNodes.forEach(IStorageProvider::requestUpdate);
            this.updatePatterns();
        }
    }

    public void onServerStartTick() {
        if (this.ticksSinceLastSync < TICKS_PER_SYNC) {
            ++this.ticksSinceLastSync;
        }
        if (this.needsSync && this.ticksSinceLastSync == TICKS_PER_SYNC) {
            this.tpeHandler.syncTeamProviders(this.providers);
            this.needsSync = false;
            this.ticksSinceLastSync = 0;
        }
    }

    private void addProvider(UUID playerUUID) {
        this.providers.putIfAbsent(playerUUID, KnowledgeService.retrieveProvider(playerUUID));
    }

    static Supplier<IKnowledgeProvider> retrieveProvider(UUID playerUUID) {
        return () -> {
            try {
                return ITransmutationProxy.INSTANCE.getKnowledgeProviderFor(playerUUID);
            }
            catch (Throwable e) {
                return TransmutationOfflineAccessor.invokeForPlayer(playerUUID);
            }
        };
    }

    List<IKnowledgeProvider> getProviders() {
        return this.providers.values().stream().map(Supplier::get).toList();
    }

    public Supplier<IKnowledgeProvider> getProviderFor(UUID uuid) {
        return this.providers.getOrDefault(uuid, this.tpeHandler.getProviderFor(uuid));
    }

    Supplier<IKnowledgeProvider> getProviderFor(Player player) {
        return this.getProviderFor(player.m_20148_());
    }

    Supplier<IKnowledgeProvider> getProviderFor(IActionHost host) {
        IGridNode node = host.getActionableNode();
        if (node != null) {
            UUID uuid = node.getOwningPlayerProfileId();
            return uuid != null ? this.getProviderFor(uuid) : null;
        }
        return null;
    }

    public EMCStorage getStorage() {
        return this.storage;
    }

    public MEStorage getStorage(IManagedGridNode node) {
        return !this.moduleNodes.isEmpty() && node.equals(this.moduleNodes.get(0)) && node.isActive() ? this.storage : NullInventory.of();
    }

    public Set<AEItemKey> getKnownItems() {
        if (this.knownItemCache == null) {
            this.knownItemCache = new HashSet<AEItemKey>();
            for (IKnowledgeProvider provider : this.getProviders()) {
                for (ItemInfo item : provider.getKnowledge()) {
                    AEItemKey key;
                    if (!IEMCProxy.INSTANCE.hasValue(item) || (key = AEItemKey.of((ItemStack)item.createStack())) == null) continue;
                    this.knownItemCache.add(key);
                }
            }
        }
        return this.knownItemCache;
    }

    public List<IPatternDetails> getPatterns(IManagedGridNode node) {
        if (!this.moduleNodes.isEmpty() && node.equals(this.moduleNodes.get(0)) && node.isActive()) {
            ArrayList<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
            for (int tier = this.storage.getHighestTier(); tier > 1; --tier) {
                patterns.add(new TransmutationPattern(tier));
            }
            for (AEItemKey item : this.getKnownItems()) {
                patterns.add(new TransmutationPattern(item, 1L));
            }
            patterns.addAll(this.temporaryPatterns);
            return patterns;
        }
        return Collections.emptyList();
    }

    public void addTemporaryPattern(IPatternDetails pattern) {
        this.temporaryPatterns.add(pattern);
        this.updatePatterns();
    }

    public void removeTemporaryPattern(IPatternDetails pattern) {
        this.temporaryPatterns.remove(pattern);
        this.updatePatterns();
    }

    void updatePatterns() {
        this.moduleNodes.forEach(ICraftingProvider::requestUpdate);
    }

    IGrid getGrid() {
        return this.grid;
    }

    BigInteger getEmc() {
        BigInteger emc = BigInteger.ZERO;
        for (Map.Entry<UUID, Supplier<IKnowledgeProvider>> entry : this.providers.entrySet()) {
            if (!this.tpeHandler.notSharingEmc(entry)) continue;
            emc = emc.add(entry.getValue().get().getEmc());
        }
        return emc;
    }

    public boolean isTrackingPlayer(Player player) {
        UUID uuid = player.m_20148_();
        return this.providers.containsKey(uuid) || this.tpeHandler.isPlayerInTrackedTeam(uuid);
    }

    void syncEmc() {
        this.needsSync = true;
    }
}

