/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.reporting;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.core.sync.BasePacketHandler;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IncrementalUpdateHelper;
import gripe._90.appliede.me.reporting.GridInventoryEMCEntry;
import gripe._90.appliede.mixin.tooltip.BasePacketAccessor;
import gripe._90.appliede.mixin.tooltip.MEInventoryUpdatePacketAccessor;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class MEInventoryUpdatePacketBuilder
extends MEInventoryUpdatePacket.Builder {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 524288;
    private static final int INITIAL_BUFFER_CAPACITY = 2048;
    private final List<MEInventoryUpdatePacket> packets = new ArrayList<MEInventoryUpdatePacket>();
    private final int containerId;
    @Nullable
    private AEKeyFilter filter;
    @Nullable
    private FriendlyByteBuf data;
    private int itemCountOffset = -1;
    private int itemCount;

    public MEInventoryUpdatePacketBuilder(int containerId, boolean fullUpdate) {
        super(containerId, fullUpdate);
        this.containerId = containerId;
    }

    public void setFilter(@Nullable AEKeyFilter filter) {
        this.filter = filter;
    }

    public void addChanges(IncrementalUpdateHelper updateHelper, KeyCounter networkStorage, Set<AEKey> craftables, KeyCounter requestables, Set<AEItemKey> transmutables) {
        for (AEKey key : updateHelper) {
            GridInventoryEntry entry;
            boolean transmutable;
            AEKey sendKey;
            if (this.filter != null && !this.filter.matches(key)) continue;
            Long serial = updateHelper.getSerial(key);
            if (serial == null) {
                sendKey = key;
                serial = updateHelper.getOrAssignSerial(key);
            } else {
                sendKey = null;
            }
            long storedAmount = networkStorage.get(key);
            boolean craftable = craftables.contains(key);
            long requestable = requestables.get(key);
            boolean bl = transmutable = key instanceof AEItemKey && transmutables.contains(key);
            if (storedAmount <= 0L && requestable <= 0L && !craftable) {
                entry = new GridInventoryEntry(serial.longValue(), sendKey, 0L, 0L, false);
                updateHelper.removeSerial(key);
            } else {
                entry = new GridInventoryEntry(serial.longValue(), sendKey, storedAmount, requestable, craftable);
                ((GridInventoryEMCEntry)entry).appliede$setTransmutable(transmutable);
            }
            this.add(entry);
        }
        updateHelper.commitChanges();
    }

    public void add(GridInventoryEntry entry) {
        FriendlyByteBuf data = this.ensureData();
        GridInventoryEMCEntry.writeEntry(data, entry);
        ++this.itemCount;
        if (data.writerIndex() >= 524288 || this.itemCount >= Short.MAX_VALUE) {
            this.flushData();
        }
    }

    private void flushData() {
        if (this.data != null) {
            this.data.markWriterIndex();
            this.data.writerIndex(this.itemCountOffset);
            this.data.writeShort(this.itemCount);
            this.data.resetWriterIndex();
            MEInventoryUpdatePacket packet = MEInventoryUpdatePacketAccessor.create();
            ((BasePacketAccessor)packet).invokeConfigureWrite(this.data);
            this.packets.add(packet);
            this.data = null;
            this.itemCountOffset = -1;
            this.itemCount = 0;
        }
    }

    private FriendlyByteBuf ensureData() {
        if (this.data == null) {
            this.data = this.createPacketHeader();
        }
        return this.data;
    }

    private FriendlyByteBuf createPacketHeader() {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer((int)2048));
        data.writeInt(BasePacketHandler.PacketTypes.ME_INVENTORY_UPDATE.getPacketId());
        data.m_130130_(this.containerId);
        data.writeBoolean(false);
        this.itemCountOffset = data.writerIndex();
        data.writeShort(0);
        return data;
    }

    public List<MEInventoryUpdatePacket> build() {
        this.flushData();
        return this.packets;
    }
}

