/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.liquifier;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.smashingmods.alchemistry.common.recipe.liquifier.LiquifierRecipe;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class LiquifierRecipeSerializer<T extends LiquifierRecipe>
implements RecipeSerializer<T> {
    private final IFactory<T> factory;

    public LiquifierRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
        String group;
        String string = group = pSerializedRecipe.has("group") ? pSerializedRecipe.get("group").getAsString() : "liquifier";
        if (!pSerializedRecipe.has("input")) {
            throw new JsonSyntaxException("Missing input, expected to find an object.");
        }
        IngredientStack input = IngredientStack.fromJson((JsonObject)pSerializedRecipe.getAsJsonObject("input"));
        if (!pSerializedRecipe.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find an object.");
        }
        JsonObject outputObject = pSerializedRecipe.getAsJsonObject("result");
        ResourceLocation fluidLocation = new ResourceLocation(outputObject.get("fluid").getAsString());
        int fluidAmount = outputObject.has("amount") ? outputObject.get("amount").getAsInt() : 1000;
        FluidStack output = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation)), fluidAmount);
        return (T)((Object)((LiquifierRecipe)((Object)this.factory.create(pRecipeId, group, input, output))));
    }

    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String group = pBuffer.m_130136_(Short.MAX_VALUE);
        IngredientStack input = IngredientStack.fromNetwork((FriendlyByteBuf)pBuffer);
        FluidStack output = pBuffer.readFluidStack();
        return (T)((Object)((LiquifierRecipe)((Object)this.factory.create(pRecipeId, group, input, output))));
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        ((LiquifierRecipe)((Object)pRecipe)).getInput().toNetwork(pBuffer);
        pBuffer.writeFluidStack(((LiquifierRecipe)((Object)pRecipe)).getOutput());
    }

    public static interface IFactory<T extends Recipe<Inventory>> {
        public T create(ResourceLocation var1, String var2, IngredientStack var3, FluidStack var4);
    }
}

