/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.dissolver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.smashingmods.alchemistry.common.recipe.dissolver.ProbabilityGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ProbabilitySet {
    private final List<ProbabilityGroup> probabilityGroups;
    private final boolean weighted;
    private final int rolls;

    public ProbabilitySet(List<ProbabilityGroup> pProbabilityGroups) {
        this(pProbabilityGroups, true, 1);
    }

    public ProbabilitySet(List<ProbabilityGroup> pProbabilityGroups, boolean pWeighted, int pRolls) {
        this.probabilityGroups = pProbabilityGroups;
        this.weighted = pWeighted;
        this.rolls = pRolls;
    }

    public JsonElement serialize() {
        JsonObject toReturn = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        toReturn.add("rolls", (JsonElement)new JsonPrimitive((Number)this.rolls));
        toReturn.add("weighted", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.weighted)));
        for (ProbabilityGroup group : this.probabilityGroups) {
            jsonArray.add(group.serialize());
        }
        toReturn.add("groups", (JsonElement)jsonArray);
        return toReturn;
    }

    public void toNetwork(FriendlyByteBuf pBuffer) {
        pBuffer.writeInt(this.probabilityGroups.size());
        pBuffer.writeInt(this.rolls);
        pBuffer.writeBoolean(this.weighted);
        for (ProbabilityGroup group : this.probabilityGroups) {
            group.toNetwork(pBuffer);
        }
    }

    public static ProbabilitySet fromNetwork(FriendlyByteBuf pbuffer) {
        ArrayList<ProbabilityGroup> groupArrayList = new ArrayList<ProbabilityGroup>();
        int size = pbuffer.readInt();
        int rolls = pbuffer.readInt();
        boolean weighted = pbuffer.readBoolean();
        for (int index = 0; index < size; ++index) {
            groupArrayList.add(ProbabilityGroup.fromNetwork(pbuffer));
        }
        return new ProbabilitySet(groupArrayList, weighted, rolls);
    }

    public NonNullList<ItemStack> calculateOutput() {
        NonNullList toReturn = NonNullList.m_122779_();
        Random random = new Random();
        block0: for (int i = 1; i <= this.rolls; ++i) {
            double totalProbability = this.getTotalProbability();
            double targetProbability = random.nextDouble();
            if (this.weighted) {
                double outputProbability = 0.0;
                for (ProbabilityGroup group : this.probabilityGroups) {
                    if (!((outputProbability += group.getProbability() / totalProbability) >= targetProbability)) continue;
                    toReturn.addAll(group.getOutput());
                    continue block0;
                }
                continue;
            }
            if (totalProbability / 100.0 < targetProbability) {
                return toReturn;
            }
            for (ProbabilityGroup group : this.probabilityGroups) {
                if (!(group.getProbability() >= (double)random.nextInt(101))) continue;
                toReturn.addAll(group.getOutput());
            }
        }
        return toReturn;
    }

    public List<ProbabilityGroup> getProbabilityGroups() {
        return this.probabilityGroups;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public int getRolls() {
        return this.rolls;
    }

    private double getTotalProbability() {
        return ProbabilitySet.getTotalProbability(this.probabilityGroups);
    }

    private static double getTotalProbability(List<ProbabilityGroup> pGroups) {
        return pGroups.stream().mapToDouble(ProbabilityGroup::getProbability).sum();
    }

    public ProbabilitySet copy() {
        return new ProbabilitySet(List.copyOf(this.probabilityGroups), this.weighted, this.rolls);
    }

    public static class Builder {
        private final List<ProbabilityGroup> groups = new ArrayList<ProbabilityGroup>();
        private boolean weighted = false;
        private int rolls = 1;

        public static Builder createSet() {
            return new Builder();
        }

        public Builder addGroup(ProbabilityGroup pGroup) {
            this.groups.add(pGroup);
            return this;
        }

        public Builder addGroup(List<ItemStack> itemStacks) {
            this.groups.add(new ProbabilityGroup(itemStacks));
            return this;
        }

        public Builder addGroup(List<ItemStack> itemStacks, double pProbability) {
            this.groups.add(new ProbabilityGroup(itemStacks, pProbability));
            return this;
        }

        public Builder addGroup(ItemStack ... pItemStacks) {
            this.groups.add(new ProbabilityGroup(Arrays.asList(pItemStacks)));
            return this;
        }

        public Builder addGroup(double pProbability, ItemStack ... pItemStacks) {
            if (pItemStacks.length == 0) {
                this.groups.add(new ProbabilityGroup(List.of(ItemStack.f_41583_), pProbability));
            } else {
                this.groups.add(new ProbabilityGroup(Arrays.asList(pItemStacks), pProbability));
            }
            return this;
        }

        public Builder rolls(int rolls) {
            this.rolls = rolls;
            return this;
        }

        public Builder weighted() {
            this.weighted = true;
            return this;
        }

        public ProbabilitySet build() {
            double totalProbability = ProbabilitySet.getTotalProbability(this.groups);
            if (!this.weighted && totalProbability < 100.0) {
                double nothingProbability = 100.0 - totalProbability;
                this.addGroup(nothingProbability, new ItemStack((ItemLike)Items.f_41852_));
            }
            return new ProbabilitySet(this.groups, this.weighted, this.rolls);
        }
    }
}

