/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.fission;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.Config;
import com.smashingmods.alchemistry.common.block.fission.FissionControllerMenu;
import com.smashingmods.alchemistry.common.block.reactor.AbstractReactorBlockEntity;
import com.smashingmods.alchemistry.common.block.reactor.ReactorType;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemistry.common.recipe.fission.FissionRecipe;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import com.smashingmods.chemlib.common.items.ElementItem;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FissionControllerBlockEntity
extends AbstractReactorBlockEntity {
    private FissionRecipe currentRecipe;
    private ResourceLocation recipeId;

    public FissionControllerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.FISSION_CONTROLLER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.setReactorType(ReactorType.FISSION);
        this.setEnergyPerTick((Integer)Config.Common.fissionEnergyPerTick.get());
        this.setMaxProgress((Integer)Config.Common.fissionTicksPerOperation.get());
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            RecipeRegistry.getFissionRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(this::setRecipe);
        }
        super.onLoad();
    }

    public void updateRecipe() {
        if (!(this.f_58857_ == null || this.f_58857_.m_5776_() || this.getInputHandler().isEmpty() || this.isRecipeLocked())) {
            RecipeRegistry.getFissionRecipe(recipe -> ItemStack.m_150942_((ItemStack)recipe.getInput(), (ItemStack)this.getInputHandler().getStackInSlot(0)), this.f_58857_).ifPresent(recipe -> {
                if (this.currentRecipe == null || !((Object)((Object)this.currentRecipe)).equals(recipe)) {
                    this.setProgress(0);
                    this.setRecipe(recipe.copy());
                }
            });
        }
    }

    public boolean canProcessRecipe() {
        if (this.currentRecipe != null) {
            FissionRecipe tempRecipe = this.currentRecipe.copy();
            ItemStack input = this.getInputHandler().getStackInSlot(0);
            ItemStack output1 = this.getOutputHandler().getStackInSlot(0);
            ItemStack output2 = this.getOutputHandler().getStackInSlot(1);
            return !(this.getEnergyHandler().getEnergyStored() < (Integer)Config.Common.fissionEnergyPerTick.get() || !ItemStack.m_150942_((ItemStack)input, (ItemStack)tempRecipe.getInput()) || input.m_41613_() < tempRecipe.getInput().m_41613_() || !ItemStack.m_150942_((ItemStack)output1, (ItemStack)tempRecipe.getOutput1()) && !output1.m_41619_() || tempRecipe.getOutput1().m_41613_() + output1.m_41613_() > tempRecipe.getOutput1().m_41741_() || !ItemStack.m_150942_((ItemStack)output2, (ItemStack)tempRecipe.getOutput2()) && !output2.m_41619_() || tempRecipe.getOutput2().m_41613_() + output2.m_41613_() > tempRecipe.getOutput2().m_41741_());
        }
        return false;
    }

    public void processRecipe() {
        if (this.getProgress() < this.getMaxProgress()) {
            this.incrementProgress();
        } else {
            FissionRecipe tempRecipe = this.currentRecipe.copy();
            this.setProgress(0);
            this.getInputHandler().decrementSlot(0, tempRecipe.getInput().m_41613_());
            this.getOutputHandler().setOrIncrement(0, tempRecipe.getOutput1());
            this.getOutputHandler().setOrIncrement(1, tempRecipe.getOutput2());
        }
        this.getEnergyHandler().extractEnergy(this.getEnergyPerTick(), false);
        this.m_6596_();
    }

    public <R extends AbstractProcessingRecipe> void setRecipe(@Nullable R pRecipe) {
        if (pRecipe instanceof FissionRecipe) {
            FissionRecipe fissionRecipe;
            this.currentRecipe = fissionRecipe = (FissionRecipe)pRecipe;
        }
    }

    public FissionRecipe getRecipe() {
        return this.currentRecipe;
    }

    public LinkedList<FissionRecipe> getAllRecipes() {
        if (this.f_58857_ != null) {
            return new LinkedList<FissionRecipe>(RecipeRegistry.getFissionRecipes(this.f_58857_));
        }
        return new LinkedList<FissionRecipe>();
    }

    public EnergyStorageHandler initializeEnergyStorage() {
        return new EnergyStorageHandler((Integer)Config.Common.fissionEnergyCapacity.get()){

            protected void onEnergyChanged() {
                FissionControllerBlockEntity.this.m_6596_();
            }
        };
    }

    public ProcessingSlotHandler initializeInputHandler() {
        return new ProcessingSlotHandler(1){

            protected void onContentsChanged(int slot) {
                FissionControllerBlockEntity.this.setCanProcess(FissionControllerBlockEntity.this.canProcessRecipe());
                FissionControllerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int pSlot, @NotNull ItemStack pItemStack) {
                if (FissionControllerBlockEntity.this.currentRecipe != null && FissionControllerBlockEntity.this.isRecipeLocked()) {
                    return ItemStack.m_150942_((ItemStack)FissionControllerBlockEntity.this.currentRecipe.getInput(), (ItemStack)pItemStack);
                }
                return pItemStack.m_41720_() instanceof ElementItem;
            }
        };
    }

    public ProcessingSlotHandler initializeOutputHandler() {
        return new ProcessingSlotHandler(2){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        };
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        if (this.currentRecipe != null) {
            pTag.m_128359_("recipeId", this.currentRecipe.m_6423_().toString());
        }
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recipeId = ResourceLocation.m_135820_((String)pTag.m_128461_("recipeId"));
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            RecipeRegistry.getFissionRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(recipe -> {
                if (!((Object)recipe).equals((Object)this.currentRecipe)) {
                    this.setRecipe(recipe);
                    Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new FissionControllerMenu(pContainerId, pInventory, (BlockEntity)this);
    }
}

