/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.EnumMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.utils.ColorSource;

public abstract class SidedLightSourceBlock
extends SidePartBlock
implements IColored,
IWrenchUse {
    private final ColorSource _color;
    public static final VoxelShape MountShape = SidedLightSourceBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    public static final VoxelShape MountShapeXl = SidedLightSourceBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);

    public SidedLightSourceBlock(ColorSource color, BlockBehaviour.Properties properties) {
        super(properties.m_60955_().m_155954_(2.0f));
        this._color = color;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)StateProperties.Xl, (Comparable)Boolean.valueOf(false)));
    }

    public abstract EnumSet<Direction> getValidMountDirections();

    @NotNull
    public abstract VoxelShape m_5940_(@NotNull BlockState var1, @NotNull BlockGetter var2, @NotNull BlockPos var3, @NotNull CollisionContext var4);

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{StateProperties.Xl});
    }

    protected abstract EnumMap<DyeColor, BlockContent> getCurrentMap(int var1, BlockState var2);

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        EnumMap<DyeColor, BlockContent> currentMap = this.getCurrentMap(0, state);
        return new ItemStack((ItemLike)currentMap.get(DyeColor.WHITE).block(), 1);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Player player = context.m_43723_();
        ItemStack offhandStack = player == null ? ItemStack.f_41583_ : player.m_21206_();
        BlockState state = super.m_5573_(context);
        if (state == null || !this.getValidMountDirections().contains(context.m_43719_().m_122424_())) {
            return null;
        }
        DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
        if (color != null) {
            FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
            state = this.getCurrentMap(15, state).get(color).block().m_152465_(state);
        }
        return state;
    }

    public static boolean dye(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, EnumMap<DyeColor, BlockContent> currentMap, DyeColor dyeColor) {
        BlockContent blockType = currentMap.get(dyeColor);
        if (dyeColor == null || blockType.block() == state.m_60734_()) {
            return false;
        }
        BlockState newState = blockType.block().m_152465_(state);
        level.m_7731_(pos, newState, 11);
        return true;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        InteractionResult wrenchResult;
        DyeColor dyeColor;
        ItemStack stack = player.m_21120_(interactionHand);
        EnumMap<DyeColor, BlockContent> currentMap = this.getCurrentMap(state.getLightEmission((BlockGetter)level, pos), state);
        if (SidedLightSourceBlock.dye(state, level, pos, currentMap, dyeColor = DyeColor.getColor((ItemStack)stack))) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (IWrenchUse.hasWrenchLikeAction((Player)player, (ItemStack)stack, (boolean)true) && (wrenchResult = this.onWrenchUsed(state, level, pos, player, interactionHand, hit)) != null) {
            return wrenchResult;
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return this._color.getColor();
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return this._color.getColor();
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType pathComputationType) {
        return pathComputationType == PathComputationType.AIR;
    }

    public static interface StateProperties {
        public static final BooleanProperty Xl = BooleanProperty.m_61465_((String)"xl");
    }
}

