/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.utils;

import java.util.ArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import oshi.util.tuples.Pair;
import tv.soaryn.xycraft.machines.config.EnergyType;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesCapabilities;
import tv.soaryn.xycraft.machines.content.capabilities.item.IXynergyStorage;

public class EnergyUtils {
    public static IXynergyStorage DummyEnergyStorage = new IXynergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    };

    public static boolean playerHasEnergyToExtract(Player player, int amount, boolean simulate) {
        ArrayList<Pair> powerProviders = new ArrayList<Pair>();
        int energyGathered = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            IEnergyStorage handler;
            int extracted;
            if (stack.m_41619_() || (extracted = (handler = EnergyUtils.getHandler(stack)).extractEnergy(amount - energyGathered, true)) == 0) continue;
            powerProviders.add(new Pair((Object)stack, (Object)handler));
            if ((energyGathered += extracted) < amount) continue;
            break;
        }
        if (energyGathered >= amount && !simulate) {
            int energyExtracted = amount;
            for (Pair powerProvider : powerProviders) {
                if ((energyExtracted -= ((IEnergyStorage)powerProvider.getB()).extractEnergy(energyExtracted, false)) > 0) continue;
                return true;
            }
        }
        return energyGathered >= amount;
    }

    private static IEnergyStorage getHandler(ItemStack stack) {
        return switch ((EnergyType)((Object)MachinesConfig.EnergyParadigm.get())) {
            default -> throw new IncompatibleClassChangeError();
            case EnergyType.Xynergy -> (IXynergyStorage)stack.getCapability(MachinesCapabilities.Common.Xynergy).orElse((Object)DummyEnergyStorage);
            case EnergyType.ForgeEnergy -> (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse((Object)DummyEnergyStorage);
        };
    }
}

