/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;

public record CBFreezeBlockPacket(BlockPos pos, BlockState state) implements Packet.ClientBound
{
    public static final BinarySerializer<CBFreezeBlockPacket> SERDES = BinarySerializer.ofType(CBFreezeBlockPacket::new, CBFreezeBlockPacket::pos, (BinarySerializer)Serializer.BLOCK_POS, CBFreezeBlockPacket::state, (BinarySerializer)Serializer.BLOCK_STATE);
    static final VoxelShape _full = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public void handle(Packet.ClientBound.Context context) {
        context.enqueueMainThread(() -> {
            BlockPos pos = this.pos();
            BlockState state = this.state();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
            VoxelShape voxelshape = state.m_60808_((BlockGetter)level, pos);
            if (voxelshape.m_83281_()) {
                voxelshape = _full;
            }
            voxelshape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double d1 = Math.min(1.0, maxX - minX);
                double d2 = Math.min(1.0, maxY - minY);
                double d3 = Math.min(1.0, maxZ - minZ);
                double i = Math.max(2.0, (double)Mth.m_14165_((double)(d1 / 0.25)));
                double j = Math.max(2.0, (double)Mth.m_14165_((double)(d2 / 0.25)));
                double k = Math.max(2.0, (double)Mth.m_14165_((double)(d3 / 0.25)));
                int x = 0;
                while ((double)x < i) {
                    int y = 0;
                    while ((double)y < j) {
                        int z = 0;
                        while ((double)z < k) {
                            double d4 = ((double)x + 0.5) / i;
                            double d5 = ((double)y + 0.5) / j;
                            double d6 = ((double)z + 0.5) / k;
                            double d7 = d4 * d1 + minX;
                            double d8 = d5 * d2 + minY;
                            double d9 = d6 * d3 + minZ;
                            particleEngine.m_107344_(new TerrainParticle(level, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, pos).updateSprite(state, pos));
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            });
        });
    }
}

