/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.data;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class AutoSmeltLootModifier
extends LootModifier {
    public static final Supplier<Codec<AutoSmeltLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AutoSmeltLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AutoSmeltLootModifier::new)));

    public AutoSmeltLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> originalLoot, LootContext context) {
        ObjectArrayList newLoot = new ObjectArrayList();
        originalLoot.forEach(stack -> {
            Optional optional = context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_());
            if (optional.isPresent()) {
                SmeltingRecipe recipe = (SmeltingRecipe)optional.get();
                ItemStack smeltedItemStack = recipe.m_8043_(context.m_78952_().m_9598_());
                if (!smeltedItemStack.m_41619_()) {
                    ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)smeltedItemStack, (int)(stack.m_41613_() * smeltedItemStack.m_41613_()));
                    newLoot.add((Object)copy);
                } else {
                    newLoot.add(stack);
                }
            } else {
                newLoot.add(stack);
            }
        });
        return newLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

