/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;

public abstract class BlockIngredient
extends Ingredient {
    public static final ResourceLocation INGREDIENT_ID = new ResourceLocation("xycraft", "blockstate");
    public final List<StatePropertiesPredicate> predicates;
    public static IIngredientSerializer<BlockIngredient> SERIALIZER = new Serializer();

    protected BlockIngredient(List<StatePropertiesPredicate> blockstateMatchers) {
        super(Stream.empty());
        this.predicates = blockstateMatchers;
    }

    protected abstract boolean matchesBlock(Block var1);

    protected abstract Pair<String, JsonElement> getJSON();

    @Nonnull
    public abstract List<Block> getMatchingBlocks();

    public boolean isSimple() {
        return false;
    }

    public ItemStack @NotNull [] m_43908_() {
        return new ItemStack[0];
    }

    public boolean test(@Nullable ItemStack testItem) {
        if (testItem == null) {
            return false;
        }
        Block block = Block.m_49814_((Item)testItem.m_41720_());
        return block != Blocks.f_50016_ && this.testBlock(block.m_49966_());
    }

    public boolean testBlock(BlockState state) {
        if (!this.matchesBlock(state.m_60734_())) {
            return false;
        }
        return this.predicates.size() == 0 || this.predicates.stream().anyMatch(pred -> pred.m_67667_(state));
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject result = new JsonObject();
        result.addProperty("type", INGREDIENT_ID.toString());
        Pair<String, JsonElement> blockData = this.getJSON();
        result.add((String)blockData.getFirst(), (JsonElement)blockData.getSecond());
        if (this.predicates.size() == 1) {
            result.add("properties", this.predicates.get(0).m_67666_());
        } else if (this.predicates.size() > 1) {
            result.add("properties", (JsonElement)this.predicates.stream().map(StatePropertiesPredicate::m_67666_).collect(Collector.of(JsonArray::new, JsonArray::add, (a, b) -> {
                a.addAll(b);
                return a;
            }, new Collector.Characteristics[0])));
        }
        return result;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<BlockIngredient> {
        private Serializer() {
        }

        @Nonnull
        public BlockIngredient parse(@Nonnull JsonObject json) {
            List<Object> predicates;
            JsonElement props = json.get("properties");
            if (props == null) {
                predicates = Collections.emptyList();
            } else if (props.isJsonArray()) {
                predicates = new ArrayList(props.getAsJsonArray().size());
                for (JsonElement pred : props.getAsJsonArray()) {
                    predicates.add(StatePropertiesPredicate.m_67679_((JsonElement)pred));
                }
            } else if (props.isJsonObject()) {
                predicates = Collections.singletonList(StatePropertiesPredicate.m_67679_((JsonElement)props));
            } else {
                throw new JsonParseException("Blockstate properties must be an object or a list of property objects!");
            }
            if (json.has("block") && json.has("tag")) {
                throw new JsonParseException("A Block Ingredient entry is either a tag or a block, not both.");
            }
            if (json.has("block")) {
                JsonElement array = json.get("block");
                Object blockElems = array.isJsonArray() ? array.getAsJsonArray() : Collections.singletonList(array);
                ArrayList<Block> blocks = new ArrayList<Block>();
                Iterator iterator = blockElems.iterator();
                while (iterator.hasNext()) {
                    JsonElement blockJson = (JsonElement)iterator.next();
                    ResourceLocation blockName = new ResourceLocation(blockJson.getAsString());
                    if (!ForgeRegistries.BLOCKS.containsKey(blockName)) {
                        throw new JsonSyntaxException("Unknown block '" + blockName + "'");
                    }
                    blocks.add((Block)ForgeRegistries.BLOCKS.getValue(blockName));
                }
                return new BlockIngredientList(blocks, predicates);
            }
            if (json.has("tag")) {
                ResourceLocation tagName = new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)"tag"));
                ITag tag = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagName));
                return new TaggedBlockIngredient((ITag<Block>)tag, predicates);
            }
            throw new JsonParseException("An Block Ingredient entry needs either a tag or a block");
        }

        @Nonnull
        public BlockIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            int i;
            int blockSize = buffer.m_130242_();
            int predSize = buffer.m_130242_();
            ArrayList<Block> blocks = new ArrayList<Block>(blockSize);
            ArrayList<StatePropertiesPredicate> predicates = new ArrayList<StatePropertiesPredicate>(predSize);
            for (i = 0; i < blockSize; ++i) {
                blocks.add((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
            }
            for (i = 0; i < predSize; ++i) {
                JsonObject predicateData = GsonHelper.m_13864_((String)buffer.m_130136_(32768));
                predicates.add(StatePropertiesPredicate.m_67679_((JsonElement)predicateData.getAsJsonObject("")));
            }
            return new BlockIngredientList(blocks, predicates);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull BlockIngredient ingredient) {
            List<Block> blocks = ingredient.getMatchingBlocks();
            buffer.m_130130_(ingredient.predicates.size());
            buffer.m_130130_(blocks.size());
            for (Block block : blocks) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)block);
            }
            for (StatePropertiesPredicate pred : ingredient.predicates) {
                JsonObject predicateData = new JsonObject();
                predicateData.add("", pred.m_67666_());
                buffer.m_130070_(predicateData.toString());
            }
        }
    }

    public static class TaggedBlockIngredient
    extends BlockIngredient {
        public final ITag<Block> tag;

        public TaggedBlockIngredient(ITag<Block> tag, List<StatePropertiesPredicate> predicate) {
            super(predicate);
            this.tag = tag;
        }

        public TaggedBlockIngredient(ITag<Block> tag, StatePropertiesPredicate ... predicate) {
            super(Arrays.asList(predicate));
            this.tag = tag;
        }

        @Override
        @Nonnull
        public List<Block> getMatchingBlocks() {
            return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(this.tag.getKey()).stream().toList();
        }

        public TaggedBlockIngredient(ResourceLocation tagName, StatePropertiesPredicate ... predicates) {
            super(Arrays.asList(predicates));
            this.tag = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagName));
        }

        @Override
        protected boolean matchesBlock(Block block) {
            return this.tag.contains((Object)block);
        }

        @Override
        protected Pair<String, JsonElement> getJSON() {
            return Pair.of((Object)"tag", (Object)new JsonPrimitive(this.tag.getKey().f_203868_().toString()));
        }
    }

    public static class BlockIngredientList
    extends BlockIngredient {
        public final List<Block> blocks;

        public BlockIngredientList(List<Block> blocks, List<StatePropertiesPredicate> predicates) {
            super(predicates);
            this.blocks = blocks;
        }

        public BlockIngredientList(List<Block> blocks, StatePropertiesPredicate ... predicates) {
            super(Arrays.asList(predicates));
            this.blocks = blocks;
        }

        public BlockIngredientList(ResourceLocation blockName, StatePropertiesPredicate ... predicates) {
            super(Arrays.asList(predicates));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
            if (block == null) {
                throw new JsonSyntaxException("Unknown block '" + blockName + "'");
            }
            this.blocks = Collections.singletonList(block);
        }

        @Override
        @Nonnull
        public List<Block> getMatchingBlocks() {
            return Collections.unmodifiableList(this.blocks);
        }

        @Override
        protected boolean matchesBlock(Block block) {
            return this.blocks.stream().anyMatch(block::equals);
        }

        @Override
        protected Pair<String, JsonElement> getJSON() {
            if (this.blocks.size() == 1) {
                return Pair.of((Object)"block", (Object)new JsonPrimitive(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this.blocks.get(0))).toString()));
            }
            JsonArray array = new JsonArray();
            for (Block block : this.blocks) {
                array.add((JsonElement)new JsonPrimitive(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this.blocks.get(0))).toString()));
            }
            return Pair.of((Object)"block", (Object)array);
        }
    }
}

